/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.util.List;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.commands.archive.AbstractArchiveCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileEntryPathCompleter;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;

public class ListEntryArchiveCommand
extends AbstractArchiveCommand {
    public boolean execute() throws Exception {
        super.initialize();
        String archivePathArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg", new Object[0]));
        if (!this.validate(archivePathArg)) {
            return false;
        }
        SrampArchiveEntry entry = this.archive.getEntry(archivePathArg);
        if (entry != null) {
            BaseArtifactType metaData = entry.getMetaData();
            this.print(Messages.i18n.format("ENTRY", new Object[]{archivePathArg}), new Object[0]);
            this.print("-----", new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)metaData);
        } else {
            this.print(Messages.i18n.format("ListEntryArchive.Entry.Not.Exist", new Object[]{archivePathArg}), new Object[0]);
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            QName varName = new QName("archive", "active-archive");
            SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
            FileEntryPathCompleter delegate = new FileEntryPathCompleter(archive);
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }

    @Override
    protected boolean validate(String ... args) {
        if (!this.validateArchiveSession()) {
            return false;
        }
        return this.validateArchivePath(args[0]);
    }
}

