/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class HelpCommand
extends BuiltInShellCommand {
    private final Map<QName, Class<? extends ShellCommand>> commands;
    private final Set<String> namespaces;

    public HelpCommand(Map<QName, Class<? extends ShellCommand>> commands, Set<String> namespaces) {
        this.commands = commands;
        this.namespaces = namespaces;
    }

    @Override
    public void printUsage() {
    }

    @Override
    public void printHelp() {
    }

    public boolean execute() throws Exception {
        String namespaceOrCmdName = this.optionalArgument(0);
        if (namespaceOrCmdName == null) {
            this.printHelpAll();
        } else {
            int colonIdx = namespaceOrCmdName.indexOf(58);
            if (colonIdx == -1) {
                this.printHelpForNamespace(namespaceOrCmdName);
            } else {
                String ns = namespaceOrCmdName.substring(0, colonIdx);
                String localPart = namespaceOrCmdName.substring(colonIdx + 1);
                QName cmdName = new QName(ns, localPart);
                this.printHelpForCommand(cmdName);
            }
        }
        return true;
    }

    private void printHelpAll() {
        this.print(Messages.i18n.format("Help.COMMAND_LIST_MSG", new Object[0]), new Object[0]);
        String currentNamespace = null;
        int colCount = 0;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<QName, Class<? extends ShellCommand>> entry : this.commands.entrySet()) {
            QName cmdName = entry.getKey();
            String namespace = cmdName.getNamespaceURI();
            String name = cmdName.getLocalPart();
            if (!namespace.equals(currentNamespace)) {
                builder.append(String.format("\n\nNamespace: %1$s\n-----------------------\n", namespace));
                currentNamespace = namespace;
                builder.append(String.format("  %1$-18s", name));
                colCount = 0;
            } else {
                builder.append(String.format("%1$-18s", name));
                ++colCount;
            }
            if (colCount != 3) continue;
            builder.append("\n  ");
            colCount = 0;
        }
        this.print(builder.toString(), new Object[0]);
        this.print("\n", new Object[0]);
        this.print(Messages.i18n.format("Help.GET_HELP_1", new Object[0]), new Object[0]);
        this.print("", new Object[0]);
        this.print(Messages.i18n.format("Help.GET_HELP_2", new Object[0]), new Object[0]);
        this.print("", new Object[0]);
    }

    private void printHelpForNamespace(String namespace) {
        this.print(Messages.i18n.format("Help.COMMAND_LIST_MSG_2", new Object[]{namespace}), new Object[0]);
        for (Map.Entry<QName, Class<? extends ShellCommand>> entry : this.commands.entrySet()) {
            QName cmdName = entry.getKey();
            String ns = cmdName.getNamespaceURI();
            String name = cmdName.getLocalPart();
            if (!ns.equals(namespace)) continue;
            this.print("   " + name, new Object[0]);
        }
        this.print("", new Object[0]);
        this.print(Messages.i18n.format("Help.HELP_PER_CMD_MSG", new Object[0]), new Object[0]);
    }

    private void printHelpForCommand(QName cmdName) throws Exception {
        Class<? extends ShellCommand> commandClass = this.commands.get(cmdName);
        if (commandClass == null) {
            this.print(Messages.i18n.format("Help.INVALID_COMMAND", new Object[0]), new Object[0]);
        } else {
            ShellCommand command = commandClass.newInstance();
            this.print(Messages.i18n.format("Help.USAGE", new Object[0]), new Object[0]);
            command.printUsage();
            this.print("", new Object[0]);
            command.printHelp();
            this.print("", new Object[0]);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            String namespace = this.getNamespaceIfExist(lastArgument);
            if (StringUtils.isNotBlank((String)namespace)) {
                candidates.add(namespace);
                return 100;
            }
            for (String candidate : this.generateHelpCandidates()) {
                if (lastArgument != null && !candidate.startsWith(lastArgument)) continue;
                candidates.add(candidate);
            }
            return 0;
        }
        return -1;
    }

    private String getNamespaceIfExist(String candidate) {
        if (StringUtils.isNotBlank((String)candidate)) {
            for (String namespace : this.namespaces) {
                if (!namespace.startsWith(candidate)) continue;
                return namespace + ":";
            }
        }
        return null;
    }

    private Collection<String> generateHelpCandidates() {
        TreeSet<String> candidates = new TreeSet<String>();
        for (QName key : this.commands.keySet()) {
            String candidate = key.getNamespaceURI() + ":" + key.getLocalPart();
            candidates.add(candidate);
        }
        return candidates;
    }
}

