/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.overlord.sramp.shell.i18n.Messages;

public class ShellArguments {
    private boolean simple = false;
    private String batchFilePath = null;
    private String logFilePath = null;
    private Map<String, String> propertiesFromFile = new HashMap<String, String>();

    public ShellArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            boolean hasNext;
            String arg = args[i];
            boolean bl = hasNext = args.length > i + 1;
            if (arg.equalsIgnoreCase("-simple")) {
                this.simple = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-f") && hasNext) {
                this.batchFilePath = args[++i];
                continue;
            }
            if (arg.equals("-propertiesFile")) {
                this.getPropertiesFromFile(arg);
                continue;
            }
            if (!arg.equalsIgnoreCase("-l") || !hasNext) continue;
            this.logFilePath = args[++i];
        }
    }

    private void getPropertiesFromFile(String filePath) {
        File f = new File(filePath);
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            System.out.println("Error: " + filePath + " " + Messages.i18n.format("InvalidArgMsg.propertiesFile.not.exist", new Object[0]));
        }
        catch (IOException e) {
            System.out.println("Error: " + filePath + " " + Messages.i18n.format("InvalidArgMsg.propertiesFile.error.reading", new Object[0]) + ": " + e.getMessage());
        }
        for (String name : props.stringPropertyNames()) {
            this.propertiesFromFile.put(name, props.getProperty(name));
        }
    }

    public boolean isSimple() {
        return this.simple;
    }

    public boolean hasBatchFile() {
        return this.batchFilePath != null && this.batchFilePath.length() > 0;
    }

    public String getBatchFilePath() {
        return this.batchFilePath;
    }

    public Map<String, String> getPropertiesFromFile() {
        return this.propertiesFromFile;
    }

    public boolean hasLogFile() {
        return this.logFilePath != null && this.logFilePath.length() > 0;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }
}

