/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.commands.core.FeedTabCompleter;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class GetContentCommand
extends BuiltInShellCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        String artifactIdArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg.ArtifactId", new Object[0]));
        String outputFilePathArg = this.requiredArgument(1, Messages.i18n.format("GetContent.InvalidArgMsg.OutputPath", new Object[0]));
        if (!artifactIdArg.contains(":")) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidArtifactIdFormat", new Object[0]));
        }
        QName clientVarName = new QName("s-ramp", "client");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        BaseArtifactType artifact = null;
        String idType = artifactIdArg.substring(0, artifactIdArg.indexOf(58));
        if ("feed".equals(idType)) {
            QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            int feedIdx = Integer.parseInt(artifactIdArg.substring(artifactIdArg.indexOf(58) + 1)) - 1;
            if (feedIdx < 0 || (long)feedIdx >= rset.size()) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("FeedIndexOutOfRange", new Object[0]));
            }
            ArtifactSummary summary = rset.get(feedIdx);
            String artifactUUID = summary.getUuid();
            artifact = client.getArtifactMetaData(summary.getType(), artifactUUID);
        } else if ("uuid".equals(idType)) {
            String artifactUUID = artifactIdArg.substring(artifactIdArg.indexOf(58) + 1);
            artifact = client.getArtifactMetaData(artifactUUID);
        } else {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidArtifactIdFormat", new Object[0]));
        }
        File outFile = new File(outputFilePathArg);
        if (outFile.isFile()) {
            throw new InvalidCommandArgumentException(1, Messages.i18n.format("GetContent.OutputFileExists", new Object[]{outFile.getCanonicalPath()}));
        }
        if (outFile.isDirectory()) {
            String fileName = artifact.getName();
            outFile = new File(outFile, fileName);
        }
        if (outFile.getParentFile() != null) {
            outFile.getParentFile().mkdirs();
        }
        InputStream artifactContent = null;
        FileOutputStream outputStream = null;
        try {
            artifactContent = client.getArtifactContent(ArtifactType.valueOf((BaseArtifactType)artifact), artifact.getUuid());
            outputStream = new FileOutputStream(outFile);
            IOUtils.copy((InputStream)artifactContent, (OutputStream)outputStream);
            this.print(Messages.i18n.format("GetContent.ContentSaved", new Object[]{outFile.getCanonicalPath()}), new Object[0]);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(artifactContent);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)artifactContent);
        IOUtils.closeQuietly((OutputStream)outputStream);
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        int toReturn = FeedTabCompleter.tabCompletion(this.getArguments(), this.getContext(), lastArgument, candidates);
        if (this.getArguments().size() == 1) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return toReturn;
    }
}

