/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FileNameCompleter {
    private static final boolean OS_IS_WINDOWS;

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (candidates != null) {
            if (buffer == null) {
                buffer = "";
            }
            if (OS_IS_WINDOWS) {
                buffer = buffer.replace('/', '\\');
            }
            String translated = buffer;
            File homeDir = FileNameCompleter.getUserHome();
            if (translated.startsWith("~" + this.separator())) {
                translated = homeDir.getPath() + translated.substring(1);
            } else if (translated.startsWith("~")) {
                translated = homeDir.getParentFile().getAbsolutePath();
            } else if (!translated.startsWith(this.separator())) {
                String cwd = this.getUserDir().getAbsolutePath();
                translated = cwd + this.separator() + translated;
            }
            String lastPart = "";
            String firstPart = "";
            if (!translated.endsWith(File.separator)) {
                firstPart = translated.substring(0, translated.lastIndexOf(File.separator) + 1);
                lastPart = translated.substring(translated.lastIndexOf(File.separator) + 1);
            } else {
                firstPart = translated;
            }
            File file = new File(firstPart);
            File dir = firstPart.endsWith(this.separator()) ? file : file.getParentFile();
            File[] entries = dir == null ? new File[]{} : dir.listFiles();
            this.matchFiles(buffer, firstPart + lastPart, entries, candidates);
            if (FileNameCompleter.isWindows()) {
                ArrayList<CharSequence> copy = new ArrayList<CharSequence>(candidates);
                candidates.clear();
                for (CharSequence candidate : copy) {
                    candidates.add(candidate.toString().replace("\\", "/"));
                }
            }
        }
        return 100;
    }

    protected String separator() {
        return File.separator;
    }

    protected File getUserDir() {
        return new File(".");
    }

    protected void matchFiles(String buffer, String translated, File[] files, List<CharSequence> candidates) {
        for (File file : files) {
            String toAdd;
            if (!file.getAbsolutePath().startsWith(translated)) continue;
            if (StringUtils.isNotBlank((String)buffer)) {
                toAdd = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(buffer));
                if (file.isDirectory()) {
                    toAdd = toAdd + File.separator;
                }
                candidates.add(toAdd);
                continue;
            }
            toAdd = file.getName();
            if (file.isDirectory()) {
                toAdd = toAdd + File.separator;
            }
            candidates.add(toAdd);
        }
    }

    protected CharSequence render(File file, CharSequence name) {
        return name;
    }

    protected static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    protected static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return FileNameCompleter.getOsName().startsWith("windows");
    }

    static {
        String os = FileNameCompleter.getOsName();
        OS_IS_WINDOWS = os.contains("windows");
    }
}

