/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.commands.archive.AbstractArchiveCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileEntryPathCompleter;

public class UpdateEntryArchiveCommand
extends AbstractArchiveCommand {
    private static final Set<String> subcommands = new HashSet<String>();

    public UpdateEntryArchiveCommand() {
        subcommands.add("setContent");
        subcommands.add("setProperty");
        subcommands.add("setRelationship");
    }

    public boolean execute() throws Exception {
        super.initialize();
        String archivePathArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg.EntryPath", new Object[0]));
        String subCommandArg = this.requiredArgument(1, Messages.i18n.format("UpdateEntry.InvalidArgMsg.SubCommand", new Object[0]));
        if (!this.validate(archivePathArg)) {
            return false;
        }
        if ("setContent".equals(subCommandArg)) {
            this.executeSetContent(this.archive, archivePathArg, this.getContext());
        }
        if ("setProperty".equals(subCommandArg)) {
            this.executeSetProperty(this.archive, archivePathArg, this.getContext());
        }
        if ("setRelationship".equals(subCommandArg)) {
            this.executeSetRelationship(this.archive, archivePathArg, this.getContext());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSetContent(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        String pathToContentArg = this.requiredArgument(2, Messages.i18n.format("UpdateEntry.InvalidArgMsg.MissingPath", new Object[0]));
        File file = new File(pathToContentArg);
        if (!file.isFile()) {
            throw new InvalidCommandArgumentException(2, Messages.i18n.format("UpdateEntry.FileNotFound", new Object[]{pathToContentArg}));
        }
        FileInputStream contentStream = null;
        try {
            contentStream = FileUtils.openInputStream((File)file);
            SrampArchiveEntry entry = archive.getEntry(entryPath);
            archive.updateEntry(entry, (InputStream)contentStream);
            this.print(Messages.i18n.format("UpdateEntry.SuccessMsg", new Object[0]), new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    private void executeSetProperty(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        String propNameArg = this.requiredArgument(2, Messages.i18n.format("UpdateEntry.InvalidArgMsg.PropertyName", new Object[0]));
        String propValArg = this.requiredArgument(3, Messages.i18n.format("UpdateEntry.InvalidArgMsg.PropertyValue", new Object[0]));
        SrampArchiveEntry entry = archive.getEntry(entryPath);
        BaseArtifactType metaData = entry.getMetaData();
        if ("name".equals(propNameArg)) {
            metaData.setName(propValArg);
        } else if ("description".equals(propNameArg)) {
            metaData.setDescription(propValArg);
        } else if ("version".equals(propNameArg)) {
            metaData.setVersion(propValArg);
        } else if ("createdBy".equals(propNameArg)) {
            metaData.setCreatedBy(propValArg);
        } else if ("lastModifiedBy".equals(propNameArg)) {
            metaData.setLastModifiedBy(propValArg);
        } else if ("uuid".equals(propNameArg)) {
            metaData.setUuid(propValArg);
        } else if ("createdTimestamp".equals(propNameArg) || "lastModifiedTimestamp".equals(propNameArg)) {
            // empty if block
        }
        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)propNameArg, (String)propValArg);
        archive.updateEntry(entry, null);
        this.print(Messages.i18n.format("UpdateEntry.MetaDataSuccessMsg", new Object[0]), new Object[0]);
    }

    private void executeSetRelationship(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        throw new InvalidCommandArgumentException(0, Messages.i18n.format("UpdateEntry.NotYetImplemented.Relationships", new Object[0]));
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            QName varName = new QName("archive", "active-archive");
            SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
            FileEntryPathCompleter delegate = new FileEntryPathCompleter(archive);
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        if (this.getArguments().size() == 1) {
            for (String subcmd : subcommands) {
                if (lastArgument != null && !subcmd.startsWith(lastArgument)) continue;
                candidates.add(subcmd);
            }
        }
        return -1;
    }

    @Override
    protected boolean validate(String ... args) throws Exception {
        if (!this.validateArchiveSession()) {
            return false;
        }
        if (!this.validateArchivePath(args[0])) {
            return false;
        }
        if (!this.archive.containsEntry(args[0])) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("UpdateEntry.EntryNotFound", new Object[]{args[0]}));
        }
        return true;
    }
}

