/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.List;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class DeleteCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:delete [<artifactId>]", new Object[0]);
        this.print("\tValid formats for artifactId:", new Object[0]);
        this.print("\t  feed:<feedIndex> - an index into the most recent feed", new Object[0]);
        this.print("\t  uuid:<srampUUID> - the UUID of an s-ramp artifact", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'delete' command removes an artifact from the S-RAMP", new Object[0]);
        this.print("repository.  The artifact can be identified either by its", new Object[0]);
        this.print("unique S-RAMP uuid or else by an index into the most recent", new Object[0]);
        this.print("Feed.  Additionally, the currently active artifact can be", new Object[0]);
        this.print("deleted by omitting the <artifactId> argument.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Note: a Feed can be obtained, for example, by using the ", new Object[0]);
        this.print("s-ramp:query command.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:delete", new Object[0]);
        this.print(">  s-ramp:delete feed:1", new Object[0]);
        this.print(">  s-ramp:delete uuid:2832-3183-2937-9983", new Object[0]);
    }

    public void execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        BaseArtifactType artifact = null;
        String artifactIdArg = this.optionalArgument(0);
        if (artifactIdArg == null) {
            artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
            if (artifact == null) {
                this.print("No active S-RAMP artifact exists.  Use s-ramp:getMetaData.", new Object[0]);
                return;
            }
        } else {
            String idType = artifactIdArg.substring(0, artifactIdArg.indexOf(58));
            if ("feed".equals(idType)) {
                QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
                int feedIdx = Integer.parseInt(artifactIdArg.substring(artifactIdArg.indexOf(58) + 1)) - 1;
                if (feedIdx < 0 || (long)feedIdx >= rset.size()) {
                    throw new InvalidCommandArgumentException(0, "Feed index out of range.");
                }
                ArtifactSummary summary = rset.get(feedIdx);
                String artifactUUID = summary.getUuid();
                artifact = client.getArtifactMetaData(summary.getType(), artifactUUID);
            } else {
                if ("uuid".equals(idType)) {
                    throw new InvalidCommandArgumentException(0, "uuid: style artifact identifiers not yet implemented.");
                }
                throw new InvalidCommandArgumentException(0, "Invalid artifact id format.");
            }
        }
        try {
            client.deleteArtifact(artifact.getUuid(), ArtifactType.valueOf((BaseArtifactType)artifact));
            this.print("Successfully deleted artifact '%1$s'.", new Object[]{artifact.getName()});
        }
        catch (Exception e) {
            this.print("FAILED to delete the artifact.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty() && (lastArgument == null || "feed:".startsWith(lastArgument))) {
            QName feedVarName = new QName("s-ramp", "feed");
            QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            if (rset != null) {
                int idx = 0;
                while ((long)idx < rset.size()) {
                    String candidate = "feed:" + (idx + 1);
                    if (lastArgument == null) {
                        candidates.add(candidate);
                    }
                    if (lastArgument != null && candidate.startsWith(lastArgument)) {
                        candidates.add(candidate);
                    }
                    ++idx;
                }
            }
            return 0;
        }
        if (this.getArguments().size() == 1) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

