/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.shell.api.AbstractShellCommand;

public class ListOntologiesCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("ontology:list", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'list' command displays a list of all the ontologies", new Object[0]);
        this.print("currently known to the S-RAMP repository.  This list may be", new Object[0]);
        this.print("empty if no ontologies have yet been added to the repository.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print("> ontology:list", new Object[0]);
    }

    public void execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName feedVarName = new QName("ontology", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        try {
            List ontologies = client.getOntologies();
            this.print("Ontologies (%1$d entries)", new Object[]{ontologies.size()});
            this.print("  Idx  Base", new Object[0]);
            this.print("  ---  ----", new Object[0]);
            int idx = 1;
            for (OntologySummary ontology : ontologies) {
                String base = ontology.getBase();
                this.print("  %1$3d  %2$s", new Object[]{idx++, base});
            }
            this.getContext().setVariable(feedVarName, (Object)ontologies);
        }
        catch (Exception e) {
            this.print("FAILED to get the list of ontologies.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
    }
}

