/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.ShellCommand;

public class HelpCommand
extends AbstractShellCommand {
    private Map<QName, Class<? extends ShellCommand>> commands;

    public HelpCommand(Map<QName, Class<? extends ShellCommand>> commands) {
        this.commands = commands;
    }

    public void printUsage() {
    }

    public void printHelp() {
    }

    public void execute() throws Exception {
        String namespaceOrCmdName = this.optionalArgument(0);
        if (namespaceOrCmdName == null) {
            this.printHelpAll();
        } else {
            int colonIdx = namespaceOrCmdName.indexOf(58);
            if (colonIdx == -1) {
                this.printHelpForNamespace(namespaceOrCmdName);
            } else {
                String ns = namespaceOrCmdName.substring(0, colonIdx);
                String localPart = namespaceOrCmdName.substring(colonIdx + 1);
                QName cmdName = new QName(ns, localPart);
                this.printHelpForCommand(cmdName);
            }
        }
    }

    private void printHelpAll() {
        this.print("The S-RAMP Shell supports the following commands:", new Object[0]);
        String currentNamespace = null;
        int colCount = 0;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<QName, Class<? extends ShellCommand>> entry : this.commands.entrySet()) {
            QName cmdName = entry.getKey();
            String namespace = cmdName.getNamespaceURI();
            String name = cmdName.getLocalPart();
            if (!namespace.equals(currentNamespace)) {
                builder.append(String.format("\n\nNamespace: %1$s\n-----------------------\n", namespace));
                currentNamespace = namespace;
                builder.append(String.format("  %1$-18s", name));
                colCount = 0;
            } else {
                builder.append(String.format("%1$-18s", name));
                ++colCount;
            }
            if (colCount != 3) continue;
            builder.append("\n  ");
            colCount = 0;
        }
        this.print(builder.toString(), new Object[0]);
        this.print("\n", new Object[0]);
        this.print("To get help for a specific command, try 'help <cmdNamespace>:<cmdName>'.", new Object[0]);
        this.print("", new Object[0]);
        this.print("To execute a specific command, try '<namespace>:<commandName> <args>'.", new Object[0]);
        this.print("Some examples:", new Object[0]);
        this.print("   s-ramp:connect http://localhost:8080/s-ramp-server", new Object[0]);
        this.print("   archive:open /home/uname/files/my-package.sramp", new Object[0]);
        this.print("", new Object[0]);
    }

    private void printHelpForNamespace(String namespace) {
        this.print("The S-RAMP Shell supports the following commands for the '%1$s' namespace:", new Object[]{namespace});
        for (Map.Entry<QName, Class<? extends ShellCommand>> entry : this.commands.entrySet()) {
            QName cmdName = entry.getKey();
            String ns = cmdName.getNamespaceURI();
            String name = cmdName.getLocalPart();
            if (!ns.equals(namespace)) continue;
            this.print("   " + name, new Object[0]);
        }
        this.print("", new Object[0]);
        this.print("To get help for a specific command, try 'help <cmdNamespace>:<cmdName>'.", new Object[0]);
    }

    private void printHelpForCommand(QName cmdName) throws Exception {
        Class<? extends ShellCommand> commandClass = this.commands.get(cmdName);
        if (commandClass == null) {
            this.print("No help available:  not a valid command.", new Object[0]);
        } else {
            ShellCommand command = commandClass.newInstance();
            this.print("USAGE", new Object[0]);
            command.printUsage();
            this.print("", new Object[0]);
            command.printHelp();
            this.print("", new Object[0]);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            for (String candidate : this.generateHelpCandidates()) {
                if (lastArgument != null && !candidate.startsWith(lastArgument)) continue;
                candidates.add(candidate);
            }
            return 0;
        }
        return -1;
    }

    private Collection<String> generateHelpCandidates() {
        TreeSet<String> candidates = new TreeSet<String>();
        for (QName key : this.commands.keySet()) {
            String candidate = key.getNamespaceURI() + ":" + key.getLocalPart();
            candidates.add(candidate);
        }
        return candidates;
    }
}

