/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellContextImpl;
import org.overlord.sramp.shell.TabCompleter;
import org.overlord.sramp.shell.api.ShellContextEventHandler;

public class InteractiveShellCommandReader
extends AbstractShellCommandReader
implements ShellContextEventHandler {
    private static final QName CLIENT_NAME = new QName("s-ramp", "client");
    private ConsoleReader consoleReader;

    public InteractiveShellCommandReader(ShellCommandFactory factory, ShellContextImpl context) {
        super(factory, context);
        context.addHandler(this);
    }

    @Override
    public void open() throws IOException {
        this.consoleReader = new ConsoleReader();
        String prompt = this.defaultAnsiPrompt();
        this.consoleReader.setPrompt(prompt);
        this.consoleReader.addCompleter((Completer)new TabCompleter(this.getFactory(), this.getContext()));
    }

    private String defaultAnsiPrompt() {
        return "\u001b[1m\u001b[31ms-ramp>\u001b[0m ";
    }

    private String connectedAnsiPrompt() {
        return "\u001b[1m\u001b[32ms-ramp>\u001b[0m ";
    }

    @Override
    protected String readLine() throws IOException {
        return this.consoleReader.readLine();
    }

    @Override
    protected Writer getCommandOutput() {
        return this.consoleReader.getOutput();
    }

    @Override
    public void close() throws IOException {
        this.consoleReader.shutdown();
    }

    public void onVariableAdded(QName variableName, Object value) {
        if (CLIENT_NAME.equals(variableName)) {
            this.consoleReader.setPrompt(this.connectedAnsiPrompt());
        }
    }

    public void onVariableChanged(QName variableName, Object value) {
    }

    public void onVariableRemoved(QName variableName) {
        if (CLIENT_NAME.equals(variableName)) {
            this.consoleReader.setPrompt(this.defaultAnsiPrompt());
        }
    }
}

