/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.filters;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.overlord.commons.auth.filters.SimplePrincipal;
import org.overlord.sramp.common.SrampConfig;
import org.overlord.sramp.server.filters.MavenRepositoryAuthFilter;
import org.overlord.sramp.server.i18n.Messages;

public class MavenRepositoryAuthFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String authHeader = req.getHeader("Authorization");
        Creds credentials = this.parseAuthorizationHeader(authHeader);
        if (credentials == null) {
            SimplePrincipal principal = new SimplePrincipal(SrampConfig.getMavenReadOnlyUsername());
            principal.addRole("readonly." + SrampConfig.getJCRRepositoryName());
            this.doFilterChain(request, response, chain, principal);
        } else if (this.login(credentials, req, (HttpServletResponse)response)) {
            this.doFilterChain(request, response, chain, null);
        } else {
            this.sendAuthResponse((HttpServletResponse)response);
        }
    }

    private void sendAuthResponse(HttpServletResponse response) throws IOException {
        response.setHeader("WWW-Authenticate", String.format("BASIC realm=\"maven\"", new Object[0]));
        response.sendError(401);
    }

    protected void doFilterChain(ServletRequest request, ServletResponse response, FilterChain chain, SimplePrincipal principal) throws IOException, ServletException {
        if (principal == null) {
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ServletRequest)this.wrapRequest(request, principal), response);
        }
    }

    private HttpServletRequest wrapRequest(ServletRequest request, SimplePrincipal principal) {
        1 wrapper = new /* Unavailable Anonymous Inner Class!! */;
        return wrapper;
    }

    private Creds parseAuthorizationHeader(String authHeader) {
        if (authHeader == null) {
            return null;
        }
        if (!authHeader.toUpperCase().startsWith("BASIC ")) {
            return null;
        }
        try {
            String userpassEncoded = authHeader.substring(6);
            byte[] decoded = Base64.decodeBase64((String)userpassEncoded);
            String data = new String(decoded, "UTF-8");
            int sepIdx = data.indexOf(58);
            if (sepIdx > 0) {
                String username = data.substring(0, sepIdx);
                String password = data.substring(sepIdx + 1);
                return new Creds(username, password);
            }
            throw new RuntimeException(Messages.i18n.format("MavenRepositoryAuthFilter.InvalidCredFormat", new Object[0]));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean login(Creds credentials, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            request.login(credentials.username, credentials.password);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void destroy() {
    }
}

