/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.util.GenericType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.ArtifactNotFoundException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.ArtifactVerifier;
import org.overlord.sramp.common.ContentNotFoundException;
import org.overlord.sramp.common.FilenameRequiredException;
import org.overlord.sramp.common.InvalidArtifactCreationException;
import org.overlord.sramp.common.SrampAlreadyExistsException;
import org.overlord.sramp.common.SrampConfig;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.SrampException;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.WrongModelException;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.events.EventProducer;
import org.overlord.sramp.events.EventProducerFactory;
import org.overlord.sramp.integration.ArchiveContext;
import org.overlord.sramp.integration.ExtensionFactory;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.repository.errors.DerivedArtifactCreateException;
import org.overlord.sramp.repository.errors.DerivedArtifactDeleteException;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.overlord.sramp.server.atom.services.ArtifactResource;
import org.overlord.sramp.server.atom.services.BatchCreate;
import org.overlord.sramp.server.i18n.Messages;
import org.overlord.sramp.server.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class ArtifactResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(ArtifactResource.class);
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new /* Unavailable Anonymous Inner Class!! */;

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"application/atom+xml;type=entry"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, Entry entry) throws SrampAtomException, SrampException {
        try {
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            ArtifactVerifier verifier = new ArtifactVerifier(artifactType);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)verifier, (BaseArtifactType)artifact);
            verifier.throwError();
            if (artifactType.isDerived()) {
                throw new DerivedArtifactCreateException(artifactType.getArtifactType());
            }
            if (artifactType.isDocument()) {
                throw new InvalidArtifactCreationException(Messages.i18n.format("INVALID_DOCARTY_CREATE", new Object[0]));
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType persistedArtifact = persistenceManager.persistArtifact(artifact, null);
            Set eventProducers = EventProducerFactory.getEventProducers();
            for (EventProducer eventProducer : eventProducers) {
                eventProducer.artifactCreated(persistedArtifact);
            }
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)persistedArtifact);
            return visitor.getAtomEntry();
        }
        catch (WrongModelException e) {
            throw e;
        }
        catch (SrampAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @POST
    @Path(value="{model}/{type}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, InputStream is) throws SrampAtomException {
        ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
        if (fileName == null) {
            fileName = artifactType.getArtifactType() == ArtifactTypeEnum.Document ? "newartifact.bin" : (artifactType.getArtifactType() == ArtifactTypeEnum.XmlDocument ? "newartifact.xml" : "newartifact." + artifactType.getArtifactType().getModel());
        }
        try {
            Entry entry = this.doSlugPost(request, fileName, is, artifactType);
            return entry;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @POST
    @Path(value="autodetect")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, InputStream is) throws SrampAtomException {
        try {
            if (StringUtils.isEmpty((String)fileName)) {
                throw new FilenameRequiredException();
            }
            Entry entry = this.doSlugPost(request, fileName, is, null);
            return entry;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry doSlugPost(HttpServletRequest request, String fileName, InputStream is, ArtifactType artifactType) throws Exception {
        ArtifactContent content = null;
        ArchiveContext archiveContext = null;
        try {
            content = new ArtifactContent(fileName, is);
            if (ExtensionFactory.isArchive((ArtifactContent)content)) {
                archiveContext = ArchiveContext.createArchiveContext((ArtifactContent)content);
                if (artifactType == null) {
                    artifactType = ExtensionFactory.detect((ArtifactContent)content, (ArchiveContext)archiveContext);
                }
            } else if (artifactType == null) {
                artifactType = ExtensionFactory.detect((ArtifactContent)content);
            }
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)content.getInputStream(), (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            BaseArtifactType artifact = artifactType.newArtifactInstance();
            artifact.setName(fileName);
            if (archiveContext != null) {
                PersistenceManager persistenceManager = PersistenceFactory.newInstance();
                artifact = persistenceManager.persistArtifact(artifact, null);
                BatchCreate creates = new BatchCreate();
                archiveContext.setArchiveArtifactType(artifactType);
                Collection subFiles = archiveContext.expand();
                for (File subFile : subFiles) {
                    ArtifactType subArtifactType;
                    String pathInArchive = archiveContext.stripWorkDir(subFile.getAbsolutePath());
                    ArtifactContent subArtifactContent = new ArtifactContent(pathInArchive, subFile);
                    if (!ExtensionFactory.allowExpansionFromArchive((ArtifactContent)subArtifactContent, (ArchiveContext)archiveContext) || (subArtifactType = ExtensionFactory.detect((ArtifactContent)subArtifactContent, (ArchiveContext)archiveContext)) == null) continue;
                    String subMimeType = MimeTypes.determineMimeType((String)subFile.getName(), (InputStream)subArtifactContent.getInputStream(), (ArtifactType)subArtifactType);
                    subArtifactType.setMimeType(subMimeType);
                    BaseArtifactType subArtifact = subArtifactType.newArtifactInstance();
                    subArtifact.setName(subFile.getName());
                    SrampModelUtils.setCustomProperty((BaseArtifactType)subArtifact, (String)"expanded.from.archive.path", (String)pathInArchive);
                    SrampModelUtils.addGenericRelationship((BaseArtifactType)subArtifact, (String)"expandedFromDocument", (String)artifact.getUuid());
                    creates.add(subArtifact, subArtifactContent, subArtifactContent.getPath());
                }
                creates.execute(PersistenceFactory.newInstance());
                artifact = persistenceManager.updateArtifactContent(artifact.getUuid(), archiveContext.getArchiveArtifactType(), content);
            } else {
                artifact = this.doUpload(artifact, content, artifactType);
            }
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            return entry;
        }
        finally {
            if (content != null) {
                content.cleanup();
            }
            if (archiveContext != null) {
                archiveContext.cleanup();
            }
        }
    }

    private BaseArtifactType doUpload(BaseArtifactType artifact, ArtifactContent content, ArtifactType artifactType) throws Exception {
        if (artifactType == null) {
            return null;
        }
        if (artifactType.isDerived()) {
            throw new DerivedArtifactCreateException(artifactType.getArtifactType());
        }
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        if (!SrampModelUtils.isDocumentArtifact((BaseArtifactType)artifact)) {
            throw new InvalidArtifactCreationException(Messages.i18n.format("INVALID_DOCARTY_CREATE", new Object[0]));
        }
        artifact = persistenceManager.persistArtifact(artifact, content);
        Set eventProducers = EventProducerFactory.getEventProducers();
        for (EventProducer eventProducer : eventProducers) {
            eventProducer.artifactCreated(artifact);
        }
        return artifact;
    }

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"multipart/related"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry createMultiPart(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, MultipartRelatedInput input) throws SrampAtomException, SrampException {
        try {
            List list;
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactCreateException(artifactType.getArtifactType());
            }
            if (artifactType.isExtendedType()) {
                artifactType = ArtifactType.ExtendedDocument((String)artifactType.getExtendedType());
            }
            if ((list = input.getParts()).size() != 2) {
                throw new SrampAtomException(Messages.i18n.format("INVALID_MULTIPART_POST", new Object[]{list.size()}));
            }
            InputPart firstPart = (InputPart)list.get(0);
            InputPart secondpart = (InputPart)list.get(1);
            Entry atomEntry = (Entry)firstPart.getBody((GenericType)new /* Unavailable Anonymous Inner Class!! */);
            BaseArtifactType artifactMetaData = SrampAtomUtils.unwrapSrampArtifact((Entry)atomEntry);
            ArtifactVerifier verifier = new ArtifactVerifier(artifactType);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)verifier, (BaseArtifactType)artifactMetaData);
            verifier.throwError();
            String fileName = null;
            if (artifactMetaData.getName() != null) {
                fileName = artifactMetaData.getName();
            }
            ArtifactContent content = new ArtifactContent(fileName, (InputStream)secondpart.getBody((GenericType)new /* Unavailable Anonymous Inner Class!! */));
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)content.getInputStream(), (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifactRval = persistenceManager.persistArtifact(artifactMetaData, content);
            Set eventProducers = EventProducerFactory.getEventProducers();
            for (EventProducer eventProducer : eventProducers) {
                eventProducer.artifactCreated(artifactRval);
            }
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifactRval);
            return visitor.getAtomEntry();
        }
        catch (WrongModelException e) {
            throw e;
        }
        catch (SrampAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}")
    @Consumes(value={"application/atom+xml;type=entry"})
    public void updateMetaData(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, Entry atomEntry) throws SrampAtomException, SrampException {
        try {
            PersistenceManager persistenceManager;
            BaseArtifactType oldArtifact;
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, null);
            if (artifactType.isExtendedType()) {
                artifactType = SrampAtomUtils.getArtifactType((Entry)atomEntry);
            }
            if ((oldArtifact = (persistenceManager = PersistenceFactory.newInstance()).getArtifact(uuid, artifactType)) == null) {
                throw new ArtifactNotFoundException(uuid);
            }
            BaseArtifactType updatedArtifact = SrampAtomUtils.unwrapSrampArtifact((Entry)atomEntry);
            ArtifactVerifier verifier = new ArtifactVerifier(oldArtifact, artifactType);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)verifier, (BaseArtifactType)updatedArtifact);
            verifier.throwError();
            updatedArtifact = persistenceManager.updateArtifact(updatedArtifact, artifactType);
            Set eventProducers = EventProducerFactory.getEventProducers();
            for (EventProducer eventProducer : eventProducers) {
                eventProducer.artifactUpdated(updatedArtifact, oldArtifact);
            }
        }
        catch (WrongModelException e) {
            throw e;
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_UPDATING_META_DATA", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}/media")
    public void updateContent(@HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, InputStream is) throws SrampAtomException, SrampException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactCreateException(artifactType.getArtifactType());
            }
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)is, (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType oldArtifact = persistenceManager.getArtifact(uuid, artifactType);
            if (oldArtifact == null) {
                throw new ArtifactNotFoundException(uuid);
            }
            ArtifactContent content = new ArtifactContent(fileName, is);
            BaseArtifactType updatedArtifact = persistenceManager.updateArtifactContent(uuid, artifactType, content);
            Set eventProducers = EventProducerFactory.getEventProducers();
            for (EventProducer eventProducer : eventProducers) {
                eventProducer.artifactUpdated(updatedArtifact, oldArtifact);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_UPDATING_CONTENT", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry getMetaData(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException, SrampException {
        try {
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifact = persistenceManager.getArtifact(uuid, artifactType);
            if (!(artifact != null && (artifactType.getArtifactType().getApiType().equals((Object)artifact.getArtifactType()) || artifactType.getArtifactType().equals((Object)ArtifactTypeEnum.ExtendedArtifactType) && artifact.getArtifactType().equals((Object)BaseArtifactEnum.EXTENDED_DOCUMENT)))) {
                throw new ArtifactNotFoundException(uuid);
            }
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            return visitor.getAtomEntry();
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_META_DATA", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}/media")
    public Response getContent(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException, SrampException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType baseArtifact = persistenceManager.getArtifact(uuid, artifactType);
            if (baseArtifact == null || !artifactType.getArtifactType().getApiType().equals((Object)baseArtifact.getArtifactType())) {
                throw new ArtifactNotFoundException(uuid);
            }
            if (!(baseArtifact instanceof DocumentArtifactType)) {
                throw new ContentNotFoundException(uuid);
            }
            DocumentArtifactType documentArtifact = (DocumentArtifactType)baseArtifact;
            if (documentArtifact.getContentSize() == 0L || StringUtils.isEmpty((String)documentArtifact.getContentHash())) {
                throw new ContentNotFoundException(uuid);
            }
            ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)baseArtifact);
            MediaType mediaType = ctVizzy.getContentType();
            artifactType.setMimeType(mediaType.toString());
            InputStream artifactContent = persistenceManager.getArtifactContent(uuid, artifactType);
            4 output = new /* Unavailable Anonymous Inner Class!! */;
            String lastModifiedDate = ((SimpleDateFormat)dateFormat.get()).format(baseArtifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
            return Response.ok((Object)output, (String)artifactType.getMimeType()).header("Content-Disposition", (Object)("attachment; filename=" + baseArtifact.getName())).header("Content-Length", baseArtifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)).header("Last-Modified", (Object)lastModifiedDate).build();
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_CONTENT", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }

    @DELETE
    @Path(value="{model}/{type}/{uuid}")
    public void delete(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException, SrampException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, null);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactDeleteException(artifactType.getArtifactType());
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifact = persistenceManager.deleteArtifact(uuid, artifactType);
            Set eventProducers = EventProducerFactory.getEventProducers();
            for (EventProducer eventProducer : eventProducers) {
                eventProducer.artifactDeleted(artifact);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_DELETING_ARTY", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }

    @DELETE
    @Path(value="{model}/{type}/{uuid}/media")
    public void deleteContent(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException, SrampException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactDeleteException(artifactType.getArtifactType());
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType oldArtifact = persistenceManager.getArtifact(uuid, artifactType);
            if (oldArtifact == null) {
                throw new ArtifactNotFoundException(uuid);
            }
            BaseArtifactType updatedArtifact = persistenceManager.deleteArtifactContent(uuid, artifactType);
            Set eventProducers = EventProducerFactory.getEventProducers();
            for (EventProducer eventProducer : eventProducers) {
                eventProducer.artifactUpdated(updatedArtifact, oldArtifact);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_DELETING_ARTY_CONTENT", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }
}

