/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.devsvr;

import java.io.InputStream;
import java.security.Principal;
import java.util.EnumSet;
import java.util.EventListener;
import javax.security.auth.Subject;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.jboss.errai.bus.server.servlet.DefaultBlockingServlet;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.weld.environment.servlet.BeanManagerResourceBindingListener;
import org.jboss.weld.environment.servlet.Listener;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.commons.auth.filters.HttpRequestThreadLocalFilter;
import org.overlord.commons.auth.filters.SamlBearerTokenAuthFilter;
import org.overlord.commons.dev.server.DevServerEnvironment;
import org.overlord.commons.dev.server.ErraiDevServer;
import org.overlord.commons.dev.server.MultiDefaultServlet;
import org.overlord.commons.dev.server.discovery.ErraiWebAppModuleFromMavenDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.IModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.JarModuleFromIDEDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.JarModuleFromMavenDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.WebAppModuleFromIDEDiscoveryStrategy;
import org.overlord.commons.gwt.server.filters.GWTCacheControlFilter;
import org.overlord.commons.gwt.server.filters.ResourceCacheControlFilter;
import org.overlord.commons.ui.header.OverlordHeaderDataJS;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.devsvr.SrampDevServerEnvironment;
import org.overlord.sramp.integration.switchyard.expand.SwitchYardAppToSrampArchive;
import org.overlord.sramp.repository.jcr.JCRRepository;
import org.overlord.sramp.repository.jcr.modeshape.filters.ServletCredentialsFilter;
import org.overlord.sramp.server.atom.services.SRAMPApplication;
import org.overlord.sramp.server.filters.LocaleFilter;
import org.overlord.sramp.ui.client.shared.beans.ArtifactSummaryBean;
import org.overlord.sramp.ui.server.api.SAMLBearerTokenAuthenticationProvider;
import org.overlord.sramp.ui.server.servlets.ArtifactDownloadServlet;
import org.overlord.sramp.ui.server.servlets.ArtifactUploadServlet;
import org.overlord.sramp.ui.server.servlets.OntologyUploadServlet;

public class SrampDevServer
extends ErraiDevServer {
    public static void main(String[] args) throws Exception {
        SrampDevServer devServer = new SrampDevServer(args);
        devServer.enableDebug();
        devServer.go();
    }

    public SrampDevServer(String[] args) {
        super(args);
    }

    protected String getErraiModuleId() {
        return "s-ramp-ui";
    }

    protected void preConfig() {
        System.setProperty("sramp.modeshape.config.url", "classpath://" + JCRRepository.class.getName() + "/META-INF/modeshape-configs/inmemory-sramp-config.json");
        System.setProperty("s-ramp-ui.atom-api.authentication.provider", SAMLBearerTokenAuthenticationProvider.class.getName());
        System.setProperty("s-ramp-ui.atom-api.authentication.saml.issuer", "/s-ramp-ui");
        System.setProperty("s-ramp-ui.atom-api.authentication.saml.service", "/s-ramp-server");
        System.setProperty("s-ramp-ui.atom-api.authentication.saml.sign-assertions", "false");
        System.setProperty("overlord.resource-caching.disabled", "true");
    }

    protected DevServerEnvironment createDevEnvironment() {
        return new SrampDevServerEnvironment(this.args);
    }

    protected void addModules(DevServerEnvironment environment) {
        environment.addModule("s-ramp-ui", new IModuleDiscoveryStrategy[]{new WebAppModuleFromIDEDiscoveryStrategy(ArtifactSummaryBean.class), new ErraiWebAppModuleFromMavenDiscoveryStrategy(ArtifactSummaryBean.class)});
        environment.addModule("overlord-commons-uiheader", new IModuleDiscoveryStrategy[]{new JarModuleFromIDEDiscoveryStrategy(OverlordHeaderDataJS.class, "src/main/resources/META-INF/resources"), new JarModuleFromMavenDiscoveryStrategy(OverlordHeaderDataJS.class, "/META-INF/resources")});
    }

    protected void addModulesToJetty(DevServerEnvironment environment, ContextHandlerCollection handlers) throws Exception {
        String[] fileTypes;
        super.addModulesToJetty(environment, handlers);
        ServletContextHandler srampUI = new ServletContextHandler(1);
        srampUI.setSecurityHandler(this.createSecurityHandler(true));
        srampUI.setContextPath("/s-ramp-ui");
        srampUI.setWelcomeFiles(new String[]{"index.html"});
        srampUI.setResourceBase(environment.getModuleDir("s-ramp-ui").getCanonicalPath());
        srampUI.setInitParameter("errai.properties", "/WEB-INF/errai.properties");
        srampUI.setInitParameter("login.config", "/WEB-INF/login.config");
        srampUI.setInitParameter("users.properties", "/WEB-INF/users.properties");
        srampUI.addEventListener((EventListener)new Listener());
        srampUI.addEventListener((EventListener)new BeanManagerResourceBindingListener());
        srampUI.addFilter(HttpRequestThreadLocalFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        srampUI.addFilter(GWTCacheControlFilter.class, "/app/*", EnumSet.of(DispatcherType.REQUEST));
        srampUI.addFilter(ResourceCacheControlFilter.class, "/css/*", EnumSet.of(DispatcherType.REQUEST));
        srampUI.addFilter(ResourceCacheControlFilter.class, "/images/*", EnumSet.of(DispatcherType.REQUEST));
        srampUI.addFilter(ResourceCacheControlFilter.class, "/js/*", EnumSet.of(DispatcherType.REQUEST));
        srampUI.addFilter(org.overlord.sramp.ui.server.filters.LocaleFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder erraiServlet = new ServletHolder(DefaultBlockingServlet.class);
        erraiServlet.setInitOrder(1);
        srampUI.addServlet(erraiServlet, "*.erraiBus");
        srampUI.addServlet(new ServletHolder(ArtifactDownloadServlet.class), "/app/services/artifactDownload");
        srampUI.addServlet(new ServletHolder(ArtifactUploadServlet.class), "/app/services/artifactUpload");
        srampUI.addServlet(new ServletHolder(OntologyUploadServlet.class), "/app/services/ontologyUpload");
        ServletHolder headerDataServlet = new ServletHolder(OverlordHeaderDataJS.class);
        headerDataServlet.setInitParameter("app-id", "s-ramp-ui");
        srampUI.addServlet(headerDataServlet, "/js/overlord-header-data.js");
        ServletHolder resources = new ServletHolder((Servlet)new MultiDefaultServlet());
        resources.setInitParameter("resourceBase", "/");
        resources.setInitParameter("resourceBases", environment.getModuleDir("s-ramp-ui").getCanonicalPath() + "|" + environment.getModuleDir("overlord-commons-uiheader").getCanonicalPath());
        resources.setInitParameter("dirAllowed", "true");
        resources.setInitParameter("pathInfoOnly", "false");
        for (String fileType : fileTypes = new String[]{"html", "js", "css", "png", "gif"}) {
            srampUI.addServlet(resources, "*." + fileType);
        }
        ServletContextHandler srampServer = new ServletContextHandler(1);
        srampServer.setSecurityHandler(this.createSecurityHandler(false));
        srampServer.setContextPath("/s-ramp-server");
        ServletHolder resteasyServlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        resteasyServlet.setInitParameter("javax.ws.rs.Application", SRAMPApplication.class.getName());
        srampServer.addServlet(resteasyServlet, "/*");
        srampServer.addFilter(SamlBearerTokenAuthFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("allowedIssuers", "/s-ramp-ui,/dtgov,/dtgov-ui");
        srampServer.addFilter(LocaleFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        srampServer.addFilter(ServletCredentialsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        handlers.addHandler((Handler)srampUI);
        handlers.addHandler((Handler)srampServer);
    }

    private SecurityHandler createSecurityHandler(boolean forUI) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"overlorduser"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setSessionRenewedOnAuthentication(false);
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("overlord");
        if (forUI) {
            csh.addConstraintMapping(cm);
        }
        csh.setLoginService((LoginService)new HashLoginService(){

            public UserIdentity login(String username, Object credentials) {
                String[] roles;
                Credential credential = credentials instanceof Credential ? (Credential)credentials : Credential.getCredential((String)credentials.toString());
                MappedLoginService.KnownUser userPrincipal = new MappedLoginService.KnownUser(username, credential);
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)userPrincipal);
                subject.getPrivateCredentials().add(credential);
                for (String role : roles = new String[]{"overlorduser", "admin.sramp"}) {
                    subject.getPrincipals().add((Principal)new MappedLoginService.RolePrincipal(role));
                }
                subject.setReadOnly();
                return this._identityService.newUserIdentity(subject, (Principal)userPrincipal, roles);
            }
        });
        return csh;
    }

    protected void postStart(DevServerEnvironment environment) throws Exception {
        System.out.println("----------  Seeding the Repository  ---------------");
        SrampAtomApiClient client = new SrampAtomApiClient("http://localhost:" + this.serverPort() + "/s-ramp-server", "seeder", "seeder", true);
        String seedType = System.getProperty("s-ramp-dev-server.seed-type", "none");
        if ("switchyard".equals(seedType)) {
            this.doSwitchYardSeed(client);
        } else if ("standard".equals(seedType)) {
            this.doStandardSeed(client);
        }
        System.out.println("----------  DONE  ---------------");
        System.out.println("Now try:  \n  http://localhost:" + this.serverPort() + "/s-ramp-ui/index.html");
        System.out.println("---------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStandardSeed(SrampAtomApiClient client) throws SrampClientException, SrampAtomException {
        BaseArtifactType artifact;
        InputStream is = null;
        try {
            is = SrampDevServer.class.getResourceAsStream("colors.owl.xml");
            client.uploadOntology(is);
            System.out.println("Ontology 1 added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = SrampDevServer.class.getResourceAsStream("regional.owl.xml");
            client.uploadOntology(is);
            System.out.println("Ontology 2 added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = SrampDevServer.class.getResourceAsStream("sample.pdf");
            artifact = client.uploadArtifact(ArtifactType.Document(), is, "sample.pdf");
            artifact.setDescription("This is just a sample PDF file that is included in the dev server so that we have some content when we start up.");
            artifact.setVersion("1.0");
            client.updateArtifactMetaData(artifact);
            System.out.println("PDF added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = SrampDevServer.class.getResourceAsStream("order.xml");
            artifact = client.uploadArtifact(ArtifactType.XmlDocument(), is, "order.xml");
            artifact.getClassifiedBy().add("http://www.example.org/colors.owl#Blue");
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"foo", (String)"bar");
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"angle", (String)"obtuse");
            client.updateArtifactMetaData(artifact);
            System.out.println("XML file added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            is = SrampDevServer.class.getResourceAsStream("deriver.wsdl");
            artifact = client.uploadArtifact(ArtifactType.WsdlDocument(), is, "deriver.wsdl");
            artifact.getClassifiedBy().add("http://www.example.org/colors.owl#Red");
            artifact.getClassifiedBy().add("http://www.example.org/regional.owl#Asia");
            client.updateArtifactMetaData(artifact);
            System.out.println("WSDL added");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSwitchYardSeed(SrampAtomApiClient client) throws Exception {
        InputStream artifactsIS = ((Object)((Object)this)).getClass().getResourceAsStream("artifacts.jar");
        SwitchYardAppToSrampArchive sy2archive = null;
        SrampArchive archive = null;
        try {
            sy2archive = new SwitchYardAppToSrampArchive(artifactsIS);
            archive = sy2archive.createSrampArchive();
            client.uploadBatch(archive);
            System.out.println("Added SwitchYard app (artifacts.jar)");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
            ZipToSrampArchive.closeQuietly((ZipToSrampArchive)sy2archive);
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
        InputStream orderConsumerIS = ((Object)((Object)this)).getClass().getResourceAsStream("order-consumer.jar");
        sy2archive = null;
        archive = null;
        try {
            sy2archive = new SwitchYardAppToSrampArchive(orderConsumerIS);
            archive = sy2archive.createSrampArchive();
            client.uploadBatch(archive);
            System.out.println("Added SwitchYard app (order-consumer.jar)");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
            ZipToSrampArchive.closeQuietly((ZipToSrampArchive)sy2archive);
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
        InputStream orderServiceIS = ((Object)((Object)this)).getClass().getResourceAsStream("order-service.jar");
        sy2archive = null;
        archive = null;
        try {
            sy2archive = new SwitchYardAppToSrampArchive(orderServiceIS);
            archive = sy2archive.createSrampArchive();
            client.uploadBatch(archive);
            System.out.println("Added SwitchYard app (order-service.jar)");
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactsIS);
            ZipToSrampArchive.closeQuietly((ZipToSrampArchive)sy2archive);
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
    }
}

