/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.client.jar;

import java.util.UUID;
import org.overlord.sramp.client.jar.DiscoveredArtifact;
import org.overlord.sramp.client.jar.MetaDataFactory;
import org.overlord.sramp.common.SrampModelUtils;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Document;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XmlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;

public class DefaultMetaDataFactory
implements MetaDataFactory {
    @Override
    public BaseArtifactType createMetaData(DiscoveredArtifact artifact) {
        XmlDocument metaData = null;
        String archivePath = artifact.getArchivePath().toLowerCase();
        if (archivePath.endsWith(".xml")) {
            metaData = new XmlDocument();
            metaData.setArtifactType(BaseArtifactEnum.XML_DOCUMENT);
        } else if (artifact.getArchivePath().endsWith(".wsdl")) {
            metaData = new WsdlDocument();
            metaData.setArtifactType(BaseArtifactEnum.WSDL_DOCUMENT);
        } else if (artifact.getArchivePath().endsWith(".xsd")) {
            metaData = new XsdDocument();
            metaData.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        } else if (artifact.getArchivePath().endsWith(".wspolicy")) {
            metaData = new XsdDocument();
            metaData.setArtifactType(BaseArtifactEnum.POLICY_DOCUMENT);
        } else {
            metaData = new Document();
            metaData.setArtifactType(BaseArtifactEnum.DOCUMENT);
        }
        metaData.setUuid(UUID.randomUUID().toString());
        metaData.setName(artifact.getName());
        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"batch.archive-path", (String)artifact.getArchivePath());
        return metaData;
    }
}

