/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.demos.query;

import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.client.SrampAtomApiClient;

public class QueryDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/s-ramp-atom/s-ramp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running S-RAMP Query Demo ***\n");
        String endpoint = System.getProperty("sramp.endpoint");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        System.out.println("S-RAMP Endpoint: " + endpoint);
        SrampAtomApiClient client = new SrampAtomApiClient(endpoint);
        SrampArchive archive = new SrampArchive(QueryDemo.class.getResourceAsStream("archive-package.sramp"));
        try {
            System.out.print("Uploading some content to the S-RAMP repository...");
            client.uploadBatch(archive);
            System.out.println("done!");
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
        System.out.print("Querying the S-RAMP repository for Schemas...");
        Feed feed = client.query("/s-ramp/xsd/XsdDocument");
        System.out.println("success: " + feed.getEntries().size() + " Schema(s) found (expected AT LEAST 2)");
        System.out.print("Querying the S-RAMP repository for WSDLs...");
        feed = client.query("/s-ramp/wsdl/WsdlDocument");
        System.out.println("success: " + feed.getEntries().size() + " WSDL(s) found (expected AT LEAST 1)");
        System.out.print("Querying the S-RAMP repository for all artifacts version 1.1...");
        feed = client.query("/s-ramp[@version = '1.1']");
        System.out.println("success: " + feed.getEntries().size() + " artifact(s) found (expected AT LEAST 2)");
        System.out.print("Querying the S-RAMP repository for all artifacts version 1.2...");
        feed = client.query("/s-ramp[@version = '1.2']");
        System.out.println("success: " + feed.getEntries().size() + " artifact(s) found (expected AT LEAST 1)");
        System.out.print("Querying the S-RAMP repository for a unique artifact by name + version...");
        feed = client.query("/s-ramp[@name = 'wsrm-1.1-schema-200702.xsd' and @version = '1.1']");
        System.out.println("success: " + feed.getEntries().size() + " artifact(s) found (expected 1)");
        System.out.print("Querying the S-RAMP repository conflicting meta data...");
        feed = client.query("/s-ramp[@name = 'wsrm-1.1-schema-200702.xsd' and @version = '1.2']");
        System.out.println("success: " + feed.getEntries().size() + " artifact(s) found (expected 0)");
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

