/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.demos.deriver;

import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.AbstractXmlDeriver;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;
import org.overlord.sramp.demos.deriver.WebXmlArtifactCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebXmlDeriver
extends AbstractXmlDeriver {
    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        namespaceContext.addMapping("jee", "http://java.sun.com/xml/ns/javaee");
    }

    protected Collection<BaseArtifactType> createDerivedArtifactCollection() {
        return new WebXmlArtifactCollection();
    }

    protected void derive(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, AbstractXmlDeriver.XmlDeriverContext xmlDeriverContext) throws IOException {
        try {
            this.processDescriptor(derivedArtifacts, artifact, xmlDeriverContext.getRootElement(), xmlDeriverContext.getXpath());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void link(LinkerContext context, BaseArtifactType sourceArtifact, Collection<BaseArtifactType> derivedArtifacts) {
    }

    public void processDescriptor(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element webXml, XPath xpath) throws XPathExpressionException {
        String displayName = (String)this.query(xpath, webXml, "string(./jee:display-name)", XPathConstants.STRING);
        if (displayName != null && displayName.trim().length() > 0) {
            artifact.setName(displayName);
        }
        this.processListeners(derivedArtifacts, artifact, webXml, xpath);
        this.processFilters(derivedArtifacts, artifact, webXml, xpath);
        this.processFilterMappings(derivedArtifacts, artifact, webXml, xpath);
        this.processServlets(derivedArtifacts, artifact, webXml, xpath);
        this.processServletMappings(derivedArtifacts, artifact, webXml, xpath);
    }

    private void processListeners(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element webXml, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, webXml, "./jee:listener", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType listener = new ExtendedArtifactType();
            listener.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            listener.setUuid(UUID.randomUUID().toString());
            listener.setExtendedType("ListenerDeclaration");
            String listenerClass = (String)this.query(xpath, node, "string(./jee:listener-class)", XPathConstants.STRING);
            String displayName = (String)this.query(xpath, node, "string(./jee:display-name)", XPathConstants.STRING);
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = listenerClass;
            }
            listener.setName(displayName);
            String description = (String)this.query(xpath, node, "string(./jee:description)", XPathConstants.STRING);
            if (description != null && description.trim().length() > 0) {
                listener.setDescription(description);
            }
            SrampModelUtils.setCustomProperty((BaseArtifactType)listener, (String)"listener-class", (String)listenerClass);
            derivedArtifacts.add((BaseArtifactType)listener);
        }
    }

    private void processFilters(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element webXml, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, webXml, "./jee:filter", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            String description;
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType filter = new ExtendedArtifactType();
            filter.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            filter.setUuid(UUID.randomUUID().toString());
            filter.setExtendedType("FilterDeclaration");
            String filterClass = (String)this.query(xpath, node, "string(./jee:listener-class)", XPathConstants.STRING);
            String filterName = (String)this.query(xpath, node, "string(./jee:filter-name)", XPathConstants.STRING);
            String displayName = (String)this.query(xpath, node, "string(./jee:display-name)", XPathConstants.STRING);
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = filterClass;
            }
            if ((description = (String)this.query(xpath, node, "string(./jee:description)", XPathConstants.STRING)) != null && description.trim().length() > 0) {
                description = null;
            }
            filter.setName(filterName);
            filter.setDescription(description);
            SrampModelUtils.setCustomProperty((BaseArtifactType)filter, (String)"display-name", (String)displayName);
            SrampModelUtils.setCustomProperty((BaseArtifactType)filter, (String)"filter-class", (String)filterClass);
            derivedArtifacts.add((BaseArtifactType)filter);
        }
    }

    private void processFilterMappings(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element webXml, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, webXml, "./jee:filter-mapping", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType filterMapping = new ExtendedArtifactType();
            filterMapping.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            filterMapping.setUuid(UUID.randomUUID().toString());
            filterMapping.setExtendedType("FilterMapping");
            String filterName = (String)this.query(xpath, node, "string(./jee:filter-name)", XPathConstants.STRING);
            String urlPattern = (String)this.query(xpath, node, "string(./jee:url-pattern)", XPathConstants.STRING);
            filterMapping.setName(filterName + " Mapping");
            filterMapping.setDescription("Maps URLs of the form '" + urlPattern + "' to filter " + filterName + ".");
            SrampModelUtils.setCustomProperty((BaseArtifactType)filterMapping, (String)"filter-name", (String)filterName);
            SrampModelUtils.setCustomProperty((BaseArtifactType)filterMapping, (String)"url-pattern", (String)urlPattern);
            WebXmlArtifactCollection index = (WebXmlArtifactCollection)derivedArtifacts;
            ExtendedArtifactType filter = index.lookupFilter(filterName);
            if (filter != null) {
                SrampModelUtils.addGenericRelationship((BaseArtifactType)filterMapping, (String)"mapsFilter", (String)filter.getUuid());
            }
            derivedArtifacts.add((BaseArtifactType)filterMapping);
        }
    }

    private void processServlets(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element webXml, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, webXml, "./jee:servlet", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            String description;
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType servlet = new ExtendedArtifactType();
            servlet.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            servlet.setUuid(UUID.randomUUID().toString());
            servlet.setExtendedType("ServletDeclaration");
            String servletClass = (String)this.query(xpath, node, "string(./jee:listener-class)", XPathConstants.STRING);
            String servletName = (String)this.query(xpath, node, "string(./jee:servlet-name)", XPathConstants.STRING);
            String displayName = (String)this.query(xpath, node, "string(./jee:display-name)", XPathConstants.STRING);
            if (displayName == null || displayName.trim().length() == 0) {
                displayName = servletClass;
            }
            if ((description = (String)this.query(xpath, node, "string(./jee:description)", XPathConstants.STRING)) != null && description.trim().length() > 0) {
                description = null;
            }
            servlet.setName(servletName);
            servlet.setDescription(description);
            SrampModelUtils.setCustomProperty((BaseArtifactType)servlet, (String)"display-name", (String)displayName);
            SrampModelUtils.setCustomProperty((BaseArtifactType)servlet, (String)"servlet-class", (String)servletClass);
            derivedArtifacts.add((BaseArtifactType)servlet);
        }
    }

    private void processServletMappings(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element webXml, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, webXml, "./jee:servlet-mapping", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            ExtendedArtifactType servletMapping = new ExtendedArtifactType();
            servletMapping.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            servletMapping.setUuid(UUID.randomUUID().toString());
            servletMapping.setExtendedType("ServletMapping");
            String servletName = (String)this.query(xpath, node, "string(./jee:servlet-name)", XPathConstants.STRING);
            String urlPattern = (String)this.query(xpath, node, "string(./jee:url-pattern)", XPathConstants.STRING);
            servletMapping.setName(servletName + " Mapping");
            servletMapping.setDescription("Maps URLs of the form '" + urlPattern + "' to servlet " + servletName + ".");
            SrampModelUtils.setCustomProperty((BaseArtifactType)servletMapping, (String)"servlet-name", (String)servletName);
            SrampModelUtils.setCustomProperty((BaseArtifactType)servletMapping, (String)"url-pattern", (String)urlPattern);
            WebXmlArtifactCollection index = (WebXmlArtifactCollection)derivedArtifacts;
            ExtendedArtifactType servlet = index.lookupServlet(servletName);
            if (servlet != null) {
                SrampModelUtils.addGenericRelationship((BaseArtifactType)servletMapping, (String)"mapsServlet", (String)servlet.getUuid());
            }
            derivedArtifacts.add((BaseArtifactType)servletMapping);
        }
    }
}

