/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.ui.provider.situations;

import java.util.Date;
import org.overlord.rtgov.activity.model.Context;
import org.overlord.rtgov.analytics.situation.Situation;
import org.overlord.rtgov.ui.client.model.NameValuePairBean;
import org.overlord.rtgov.ui.client.model.SituationBean;
import org.overlord.rtgov.ui.client.model.SituationEventBean;

public class RTGovSituationsUtil {
    public static final String INTERNAL_PROPERTY_PREFIX = "_";

    private RTGovSituationsUtil() {
    }

    public static SituationBean getSituationBean(Situation situation) {
        SituationBean ret = new SituationBean();
        ret.setSituationId(situation.getId());
        if (situation.getSeverity() != null) {
            ret.setSeverity(situation.getSeverity().name().toLowerCase());
        }
        ret.setType(situation.getType());
        ret.setSubject(situation.getSubject());
        ret.setTimestamp(new Date(situation.getTimestamp()));
        ret.setDescription(situation.getDescription());
        for (String key : situation.getProperties().keySet()) {
            if (key.startsWith(INTERNAL_PROPERTY_PREFIX)) continue;
            ret.getProperties().put(key, situation.getProperties().get(key));
        }
        for (Context context : situation.getContext()) {
            if (context.getType() == null) {
                context.setType(Context.Type.Conversation);
            }
            if (context.getType() == Context.Type.Message) continue;
            ret.getContext().add(new NameValuePairBean(context.getType().name(), context.getValue()));
        }
        ret.setResubmittedSituationId((String)situation.getProperties().get("_rtgov_resubmittedSituationId"));
        return ret;
    }

    public static SituationEventBean getSituationEventBean(Situation situation) {
        SituationEventBean ret = new SituationEventBean();
        ret.setSituationId(situation.getId());
        if (situation.getSeverity() != null) {
            ret.setSeverity(situation.getSeverity().name().toLowerCase());
        }
        ret.setType(situation.getType());
        ret.setSubject(situation.getSubject());
        ret.setTimestamp(new Date(situation.getTimestamp()));
        return ret;
    }
}

