/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.common.util;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;

public final class BeanResolverUtil {
    private static final Logger LOG = Logger.getLogger(BeanResolverUtil.class.getName());

    private BeanResolverUtil() {
    }

    public static <T> T getBean(Class<T> cls) {
        Object ret = null;
        try {
            BeanManager bm = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
            Set beans = bm.getBeans(cls, new Annotation[0]);
            for (Bean b : beans) {
                CreationalContext<Object> cc = new CreationalContext<Object>(){

                    public void push(Object arg0) {
                    }

                    public void release() {
                    }
                };
                ret = b.create((CreationalContext)cc);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Resolved object=" + ret + " for bean=" + b);
                }
                if (ret == null) continue;
                break;
            }
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Failed to resolve object of type '" + cls + "'", e);
        }
        return (T)ret;
    }

    public static <T> void getBeans(Class<T> cls, List<T> list) {
        try {
            BeanManager bm = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
            Set beans = bm.getBeans(cls, new Annotation[0]);
            for (Bean b : beans) {
                CreationalContext<Object> cc = new CreationalContext<Object>(){

                    public void push(Object arg0) {
                    }

                    public void release() {
                    }
                };
                Object entry = b.create((CreationalContext)cc);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Entry=" + entry + " for bean=" + b);
                }
                list.add(entry);
            }
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "Failed to resolve elements of type '" + cls + "'", e);
        }
    }
}

