/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.internal.active.collection;

import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.overlord.rtgov.active.collection.ActiveChangeListener;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionListener;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.jmx.JMXNotifier;
import org.overlord.rtgov.internal.active.collection.ACManagementMBean;

public class ACManagement
extends NotificationBroadcasterSupport
implements ACManagementMBean,
ActiveCollectionListener {
    private static final String OBJECT_NAME_DOMAIN = "overlord.rtgov.collections";
    private static final String OBJECT_NAME_MANAGER = ":name=CollectionManager";
    private static final Logger LOG = Logger.getLogger(ACManagement.class.getName());
    private ActiveCollectionManager _acManager;

    public ACManagement(ActiveCollectionManager acm) {
        this._acManager = acm;
    }

    public void init() {
        LOG.info("Register the ACManagement MBean: " + this._acManager);
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = new ObjectName("overlord.rtgov.collections:name=CollectionManager");
            mbs.registerMBean(this, objname);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-16"), e);
        }
        this._acManager.addActiveCollectionListener(this);
    }

    public void close() {
        LOG.info("Unregister the ACManagement MBean");
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objname = new ObjectName("overlord.rtgov.collections:name=CollectionManager");
            mbs.unregisterMBean(objname);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-18"), e);
        }
    }

    @Override
    public void registered(ActiveCollection ac) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(ac, this.getObjectName(ac));
            for (ActiveChangeListener l : ac.getActiveChangeListeners()) {
                if (!(l instanceof JMXNotifier)) continue;
                mbs.registerMBean(l, new ObjectName(((JMXNotifier)l).getObjectName()));
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-19"), ac.getName()), e);
        }
    }

    protected ObjectName getObjectName(ActiveCollection ac) throws Exception {
        return new ObjectName("overlord.rtgov.collections:name=" + ac.getName());
    }

    @Override
    public void unregistered(ActiveCollection ac) {
        block3: {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.unregisterMBean(this.getObjectName(ac));
                for (ActiveChangeListener l : ac.getActiveChangeListeners()) {
                    if (!(l instanceof JMXNotifier)) continue;
                    mbs.unregisterMBean(new ObjectName(((JMXNotifier)l).getObjectName()));
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.FINER)) break block3;
                LOG.log(Level.FINER, MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-20"), ac.getName()), t);
            }
        }
    }

    @Override
    public void setHouseKeepingInterval(long interval) {
        this._acManager.setHouseKeepingInterval(interval);
    }

    @Override
    public long getHouseKeepingInterval() {
        return this._acManager.getHouseKeepingInterval();
    }
}

