/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionContext;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.QuerySpec;
import org.overlord.rtgov.active.collection.predicate.Predicate;

public class ActiveMap
extends ActiveCollection
implements Iterable<Object>,
Map<Object, Object> {
    private static final int INITIAL_CAPACITY = 1000;
    private static final Logger LOG = Logger.getLogger(ActiveMap.class.getName());
    private Map<Object, Object> _map = new HashMap<Object, Object>(1000);
    private Map<Object, Long> _mapTimestamps = new HashMap<Object, Long>(1000);
    private List<Object> _readCopy = null;

    public ActiveMap(String name) {
        super(name);
    }

    public ActiveMap(ActiveCollectionSource acs) {
        super(acs);
    }

    public ActiveMap(ActiveCollectionSource acs, Map<Object, Object> map) {
        super(acs);
        this._map = map;
    }

    protected ActiveMap(String name, int capacity) {
        super(name);
        this._map = new HashMap<Object, Object>(capacity);
        this._mapTimestamps = new HashMap<Object, Long>(capacity);
    }

    protected ActiveMap(String name, ActiveCollection parent, ActiveCollectionContext context, Predicate predicate, Map<String, Object> properties) {
        super(name, parent, context, predicate, properties);
        for (Object obj : (ActiveMap)parent) {
            Entry entry = (Entry)obj;
            if (!predicate.evaluate(context, entry.getValue())) continue;
            this.doInsert(entry.getKey(), entry.getValue());
        }
    }

    protected Map<Object, Object> deriveContent() {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        ActiveCollection parent = this.getParent();
        Predicate pred = this.getPredicate();
        ActiveCollectionContext context = this.getContext();
        if (parent != null && pred != null) {
            for (Object obj : (ActiveMap)parent) {
                Entry entry = (Entry)obj;
                if (!pred.evaluate(context, entry.getValue())) continue;
                ret.put(entry.getKey(), entry.getValue());
            }
        }
        return ret;
    }

    protected Map<Object, Object> getMap() {
        return this._map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                return this._map.size();
            }
        }
        Map<Object, Object> derived = this.deriveContent();
        return derived.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                return this._map.get(key);
            }
        }
        ActiveMap parent = (ActiveMap)this.getParent();
        Object ret = parent.get(key);
        if (this.getPredicate().evaluate(this.getContext(), ret)) {
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInsert(Object key, Object value) {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                if (key != null) {
                    this._map.put(key, value);
                    if (this.getItemExpiration() > 0L) {
                        this._mapTimestamps.put(key, System.currentTimeMillis());
                    }
                } else {
                    LOG.severe(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-11"));
                }
                this._readCopy = null;
            }
            this.inserted(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUpdate(Object key, Object value) {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                if (key != null) {
                    this._map.put(key, value);
                    if (this.getItemExpiration() > 0L) {
                        this._mapTimestamps.put(key, System.currentTimeMillis());
                    }
                } else {
                    LOG.severe(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-11"));
                }
                this._readCopy = null;
            }
            this.updated(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRemove(Object key, Object value) {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                if (key != null) {
                    value = this._map.remove(key);
                    if (this.getItemExpiration() > 0L) {
                        this._mapTimestamps.remove(key);
                    }
                } else {
                    LOG.severe(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-11"));
                }
                this._readCopy = null;
            }
            this.removed(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Object> iterator() {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                if (this._readCopy == null) {
                    this._readCopy = new ArrayList<Object>();
                    for (Object key : this._map.keySet()) {
                        Object value = this._map.get(key);
                        this._readCopy.add(new Entry(key, value));
                    }
                }
                return this._readCopy.iterator();
            }
        }
        Map<Object, Object> derived = this.deriveContent();
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (Object key : derived.keySet()) {
            Object value = derived.get(key);
            list.add(new Entry(key, value));
        }
        return list.iterator();
    }

    @Override
    protected ActiveCollection derive(String name, ActiveCollectionContext context, Predicate predicate, Map<String, Object> properties) {
        return new ActiveMap(name, this, context, predicate, properties);
    }

    @Override
    public List<Object> query(QuerySpec qs) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object obj : this) {
            ret.add(obj);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup() {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map;
            if (this.getMaxItems() > 0) {
                map = this._map;
                synchronized (map) {
                    for (int num = this.getSize() - this.getMaxItems(); num > 0; --num) {
                        this.doRemove(0, null);
                    }
                }
            }
            if (this.getItemExpiration() > 0L) {
                map = this._map;
                synchronized (map) {
                    long expiration = System.currentTimeMillis() - this.getItemExpiration();
                    for (int i = this.getSize() - 1; i >= 0; --i) {
                        if (this._mapTimestamps.get(i) >= expiration) continue;
                        this.doRemove(i, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                return this._map.isEmpty();
            }
        }
        Map<Object, Object> derived = this.deriveContent();
        return derived.isEmpty();
    }

    @Override
    public int size() {
        return this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                return this._map.containsKey(key);
            }
        }
        Map<Object, Object> derived = this.deriveContent();
        return derived.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (!this.isDerived() || this.isActive()) {
            Map<Object, Object> map = this._map;
            synchronized (map) {
                return this._map.containsValue(value);
            }
        }
        Map<Object, Object> derived = this.deriveContent();
        return derived.containsValue(value);
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public class Entry {
        private Object _key = null;
        private Object _value = null;

        public Entry(Object key, Object value) {
            this._key = key;
            this._value = value;
        }

        public void setKey(Object key) {
            this._key = key;
        }

        public Object getKey() {
            return this._key;
        }

        public void setValue(Object value) {
            this._value = value;
        }

        public Object getValue() {
            return this._value;
        }
    }
}

