/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.logging.Logger;
import org.overlord.rtgov.active.collection.ActiveCollection;
import org.overlord.rtgov.active.collection.ActiveCollectionContext;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.QuerySpec;
import org.overlord.rtgov.active.collection.predicate.Predicate;

public class ActiveList
extends ActiveCollection
implements Iterable<Object> {
    private static final int INITIAL_CAPACITY = 1000;
    private static final Logger LOG = Logger.getLogger(ActiveList.class.getName());
    private List<Object> _list = new ArrayList<Object>(1000);
    private List<Long> _listTimestamps = new ArrayList<Long>(1000);
    private List<Object> _readCopy = null;
    private boolean _copyOnRead = true;

    public ActiveList(String name) {
        super(name);
    }

    public ActiveList(ActiveCollectionSource acs) {
        super(acs);
    }

    public ActiveList(ActiveCollectionSource acs, List<Object> list) {
        super(acs);
        this._list = list;
    }

    protected ActiveList(String name, int capacity) {
        super(name);
        this._list = new ArrayList<Object>(capacity);
        this._listTimestamps = new ArrayList<Long>(capacity);
    }

    protected ActiveList(String name, ActiveCollection parent, ActiveCollectionContext context, Predicate predicate, Map<String, Object> properties) {
        super(name, parent, context, predicate, properties);
        if (this.isActive()) {
            for (Object value : (ActiveList)parent) {
                if (!predicate.evaluate(context, value)) continue;
                this.doInsert(null, value);
            }
        }
    }

    protected List<Object> deriveContent() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ActiveCollection parent = this.getParent();
        Predicate pred = this.getPredicate();
        ActiveCollectionContext context = this.getContext();
        if (parent != null && pred != null) {
            for (Object value : (ActiveList)parent) {
                if (!pred.evaluate(context, value)) continue;
                ret.add(value);
            }
        }
        return ret;
    }

    protected void setCopyOnRead(boolean b) {
        this._copyOnRead = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        if (!this.isDerived() || this.isActive()) {
            List<Object> list = this._list;
            synchronized (list) {
                return this._list.size();
            }
        }
        List<Object> derived = this.deriveContent();
        return derived.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInsert(Object key, Object value) {
        if (!this.isDerived() || this.isActive()) {
            List<Object> list = this._list;
            synchronized (list) {
                if (key == null) {
                    this._list.add(value);
                    if (this.getItemExpiration() > 0L) {
                        this._listTimestamps.add(System.currentTimeMillis());
                    }
                } else if (key instanceof Integer) {
                    this._list.add((Integer)key, value);
                    if (this.getItemExpiration() > 0L) {
                        this._listTimestamps.add((Integer)key, System.currentTimeMillis());
                    }
                } else {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-7"), key));
                }
                this._readCopy = null;
            }
            this.inserted(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUpdate(Object key, Object value) {
        if (!this.isDerived() || this.isActive()) {
            List<Object> list = this._list;
            synchronized (list) {
                if (key != null) {
                    if (key instanceof Integer) {
                        this._list.set((Integer)key, value);
                        if (this.getItemExpiration() > 0L) {
                            this._listTimestamps.set((Integer)key, System.currentTimeMillis());
                        }
                        this.updated(key, value);
                    } else {
                        LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-8"), key));
                    }
                } else {
                    int index = this._list.indexOf(value);
                    if (index == -1) {
                        LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-9"), this.getName(), value));
                    } else {
                        this._list.set(index, value);
                        if (this.getItemExpiration() > 0L) {
                            this._listTimestamps.set(index, System.currentTimeMillis());
                        }
                        this.updated(index, value);
                    }
                }
                this._readCopy = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRemove(Object key, Object value) {
        if (!this.isDerived() || this.isActive()) {
            int pos = -1;
            List<Object> list = this._list;
            synchronized (list) {
                pos = key instanceof Integer ? ((Integer)key).intValue() : this._list.indexOf(value);
                if (pos != -1) {
                    this._list.remove(pos);
                    if (this.getItemExpiration() > 0L) {
                        this._listTimestamps.remove(pos);
                    }
                } else {
                    LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-10"), this.getName(), value));
                }
                this._readCopy = null;
            }
            if (pos != -1) {
                this.removed(pos, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Object> iterator() {
        if (!this.isDerived() || this.isActive()) {
            List<Object> list = this._list;
            synchronized (list) {
                if (this._readCopy != null) {
                    return this._readCopy.iterator();
                }
                if (this._copyOnRead) {
                    this._readCopy = new ArrayList<Object>(this._list);
                    return this._readCopy.iterator();
                }
                return this._list.iterator();
            }
        }
        List<Object> derived = this.deriveContent();
        return derived.iterator();
    }

    @Override
    protected ActiveCollection derive(String name, ActiveCollectionContext context, Predicate predicate, Map<String, Object> properties) {
        return new ActiveList(name, this, context, predicate, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> query(QuerySpec qs) {
        ArrayList<Object> ret = null;
        List<Object> list = this._list;
        if (this.isDerived() && !this.isActive()) {
            list = this.deriveContent();
        }
        List<Object> list2 = list;
        synchronized (list2) {
            if ((qs.getMaxItems() == 0 || qs.getMaxItems() >= list.size()) && qs.getStyle() == QuerySpec.Style.Normal) {
                ret = new ArrayList<Object>(list);
            } else {
                int start = 0;
                int end = list.size();
                if (qs.getMaxItems() > 0 && qs.getMaxItems() <= list.size()) {
                    if (qs.getTruncate() == QuerySpec.Truncate.End) {
                        end = qs.getMaxItems();
                    } else {
                        start = list.size() - qs.getMaxItems();
                    }
                }
                ret = new ArrayList();
                if (qs.getStyle() == QuerySpec.Style.Reversed) {
                    for (int i = end - 1; i >= start; --i) {
                        ret.add(list.get(i));
                    }
                } else {
                    for (int i = start; i < end; ++i) {
                        ret.add(list.get(i));
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup() {
        if (!this.isDerived() || this.isActive()) {
            List<Object> list;
            if (this.getMaxItems() > 0) {
                list = this._list;
                synchronized (list) {
                    for (int num = this.getSize() - this.getMaxItems(); num > 0; --num) {
                        this.doRemove(0, this._list.get(0));
                    }
                }
            }
            if (this.getItemExpiration() > 0L) {
                list = this._list;
                synchronized (list) {
                    long expiration = System.currentTimeMillis() - this.getItemExpiration();
                    for (int i = this.getSize() - 1; i >= 0; --i) {
                        if (this._listTimestamps.get(i) >= expiration) continue;
                        this.doRemove(i, this._list.get(i));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (!this.isDerived() || this.isActive()) {
            List<Object> list = this._list;
            synchronized (list) {
                return this._list.isEmpty();
            }
        }
        List<Object> derived = this.deriveContent();
        return derived.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        if (!this.isDerived() || this.isActive()) {
            List<Object> list = this._list;
            synchronized (list) {
                return this._list.contains(o);
            }
        }
        List<Object> derived = this.deriveContent();
        return derived.contains(o);
    }

    public int size() {
        return this.getSize();
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object e) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection<? extends Object> c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }
}

