/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection.predicate;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import java.util.logging.Logger;
import org.overlord.rtgov.active.collection.ActiveCollectionContext;
import org.overlord.rtgov.active.collection.predicate.Predicate;

public class MVEL
extends Predicate {
    private static final Logger LOG = Logger.getLogger(MVEL.class.getName());
    public static final String RTGOV_POLICY = "rtgov.security.policy";
    private String _expression;
    private volatile Serializable _expressionCompiled;
    private static AccessControlContext RTGOV_ACC;

    public MVEL() {
    }

    public MVEL(String expr) {
        this.setExpression(expr);
    }

    public void setExpression(String expr) {
        this._expression = expr;
        this._expressionCompiled = null;
    }

    public String getExpression() {
        return this._expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evaluate(ActiveCollectionContext context, Object item) {
        Serializable expressionCompiled;
        boolean ret = false;
        if (this._expressionCompiled == null && this._expression != null) {
            MVEL mVEL = this;
            synchronized (mVEL) {
                this._expressionCompiled = org.mvel2.MVEL.compileExpression((String)this._expression);
            }
        }
        if ((expressionCompiled = this._expressionCompiled) != null) {
            MVELEvaluateAction evaluateAction = new MVELEvaluateAction(context, expressionCompiled, item);
            if (System.getSecurityManager() != null) {
                try {
                    ret = AccessController.doPrivileged(evaluateAction, RTGOV_ACC);
                }
                catch (RuntimeException re) {
                    for (Throwable cause = re.getCause(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof AccessControlException)) continue;
                        LOG.warning(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-15"), this._expression, cause.getMessage()));
                    }
                }
            } else {
                ret = (Boolean)evaluateAction.run();
            }
        }
        return ret;
    }

    public String toString() {
        return "MVEL[" + this._expression + "]";
    }

    static {
        String rtgovPolicy = System.getProperty(RTGOV_POLICY);
        if (rtgovPolicy != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                LOG.severe(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-12"));
                RTGOV_ACC = null;
            } else {
                URI rtgovPolicyResource = new File(rtgovPolicy).toURI();
                try {
                    Policy policy = Policy.getInstance("JavaPolicy", new URIParameter(rtgovPolicyResource));
                    CodeSource codeSource = new CodeSource(null, (Certificate[])null);
                    PermissionCollection perms = policy.getPermissions(codeSource);
                    ProtectionDomain[] pds = new ProtectionDomain[]{new ProtectionDomain(codeSource, perms)};
                    RTGOV_ACC = new AccessControlContext(pds);
                    LOG.info(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-13"));
                }
                catch (NoSuchAlgorithmException nsae) {
                    LOG.severe(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-14"));
                }
            }
        } else {
            RTGOV_ACC = null;
        }
    }

    private class MVELEvaluateAction
    implements PrivilegedAction<Boolean> {
        private final ActiveCollectionContext _context;
        private final Serializable _expressionCompiled;
        private final Object _item;

        MVELEvaluateAction(ActiveCollectionContext context, Serializable expressionCompiled, Object item) {
            this._context = context;
            this._expressionCompiled = expressionCompiled;
            this._item = item;
        }

        @Override
        public Boolean run() {
            Boolean ret = null;
            HashMap<String, ActiveCollectionContext> vars = new HashMap<String, ActiveCollectionContext>();
            vars.put("context", this._context);
            Object result = org.mvel2.MVEL.executeExpression((Object)this._expressionCompiled, (Object)this._item, vars);
            if (result instanceof Boolean) {
                ret = (Boolean)Boolean.class.cast(result);
            } else {
                LOG.severe(MessageFormat.format(PropertyResourceBundle.getBundle("active-collection.Messages").getString("ACTIVE-COLLECTION-2"), MVEL.this._expression, result, this._item));
            }
            return ret;
        }
    }
}

