/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;

public final class ActiveCollectionManagerAccessor {
    private static final int DEFAULT_WAIT_TIME = 300000;
    private static final Logger LOG = Logger.getLogger(ActiveCollectionManagerAccessor.class.getName());
    private static ActiveCollectionManager _acManager = null;
    private static final Object SYNC = new Object();

    private ActiveCollectionManagerAccessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setActiveCollectionManager(ActiveCollectionManager manager) {
        Object object = SYNC;
        synchronized (object) {
            if (_acManager != null) {
                LOG.severe("Active collection manager already set");
            }
            _acManager = manager;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Set activity collection manager=" + manager);
            }
            SYNC.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActiveCollectionManager getActiveCollectionManager() {
        if (_acManager == null) {
            Object object = SYNC;
            synchronized (object) {
                if (_acManager == null) {
                    try {
                        SYNC.wait(ActiveCollectionManagerAccessor.getWaitTime());
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Failed to wait for ActiveCollectionManager to become available", e);
                    }
                    if (_acManager == null) {
                        LOG.severe("ActiveCollectionManager is not available");
                    }
                }
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Get activity collection manager=" + _acManager);
        }
        return _acManager;
    }

    private static long getWaitTime() {
        String waitTimeVal = System.getProperty("org.overlord.ServiceWaitTime");
        long waitTime = 300000L;
        if (waitTimeVal != null) {
            try {
                waitTime = Long.parseLong(waitTimeVal);
            }
            catch (NumberFormatException nfe) {
                LOG.warning("Failed to parse ServiceWaitTime " + waitTimeVal + ", using default value of " + waitTime);
            }
        }
        return waitTime;
    }
}

