/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.overlord.rtgov.active.collection.ActiveChangeListener;
import org.overlord.rtgov.active.collection.ActiveCollectionContext;
import org.overlord.rtgov.active.collection.ActiveCollectionMBean;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.ActiveCollectionVisibility;
import org.overlord.rtgov.active.collection.QuerySpec;
import org.overlord.rtgov.active.collection.predicate.Predicate;

public abstract class ActiveCollection
implements ActiveCollectionMBean,
Iterable<Object> {
    private String _name = null;
    private ActiveCollectionVisibility _visibility = null;
    private List<ActiveChangeListener> _listeners = new ArrayList<ActiveChangeListener>();
    private ActiveCollectionAdapter _adapter = null;
    private long _itemExpiration = 0L;
    private int _maxItems = 0;
    private int _highWaterMark = 0;
    private boolean _highWaterMarkWarningIssued = false;
    private Map<String, Object> _properties = null;

    public ActiveCollection(String name) {
        this._name = name;
    }

    public ActiveCollection(ActiveCollectionSource acs) {
        this._name = acs.getName();
        this._visibility = acs.getVisibility();
        this._itemExpiration = acs.getItemExpiration();
        this._maxItems = acs.getMaxItems();
        this._highWaterMark = acs.getHighWaterMark();
        this._properties = acs.getProperties();
    }

    protected ActiveCollection(String name, ActiveCollection parent, ActiveCollectionContext context, Predicate predicate, Map<String, Object> properties) {
        this(name);
        this._adapter = new ActiveCollectionAdapter(parent, context, predicate);
        this._visibility = parent.getVisibility();
        this._properties = properties;
    }

    @Override
    public String getName() {
        return this._name;
    }

    protected ActiveCollection getParent() {
        return this._adapter == null ? null : this._adapter.getParent();
    }

    protected Predicate getPredicate() {
        return this._adapter == null ? null : this._adapter.getPredicate();
    }

    protected ActiveCollectionContext getContext() {
        return this._adapter == null ? null : this._adapter.getContext();
    }

    public ActiveCollectionVisibility getVisibility() {
        return this._visibility;
    }

    protected void setVisibility(ActiveCollectionVisibility visibility) {
        this._visibility = visibility;
    }

    @Override
    public long getItemExpiration() {
        return this._itemExpiration;
    }

    protected void setItemExpiration(long expire) {
        this._itemExpiration = expire;
    }

    @Override
    public int getMaxItems() {
        return this._maxItems;
    }

    protected void setMaxItems(int max) {
        this._maxItems = max;
    }

    @Override
    public int getHighWaterMark() {
        return this._highWaterMark;
    }

    protected void setHighWaterMark(int highWaterMark) {
        this._highWaterMark = highWaterMark;
    }

    protected boolean getHighWaterMarkWarningIssued() {
        return this._highWaterMarkWarningIssued;
    }

    protected void setHighWaterMarkWarningIssued(boolean issued) {
        this._highWaterMarkWarningIssued = issued;
    }

    protected Object getProperty(String name, Object def) {
        Object ret;
        Object object = ret = this._properties == null ? null : this._properties.get(name);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    protected boolean isDerived() {
        return this._adapter != null;
    }

    protected boolean isActive() {
        return (Boolean)this.getProperty("active", true);
    }

    protected abstract void cleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveChangeListener(ActiveChangeListener l) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveChangeListener(ActiveChangeListener l) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(l);
        }
    }

    public List<ActiveChangeListener> getActiveChangeListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    @Override
    public abstract int getSize();

    protected abstract void insert(Object var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inserted(Object key, Object value) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            if (this._listeners.size() > 0) {
                for (ActiveChangeListener l : this._listeners) {
                    l.inserted(key, value);
                }
            }
        }
    }

    protected abstract void update(Object var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updated(Object key, Object value) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            if (this._listeners.size() > 0) {
                for (ActiveChangeListener l : this._listeners) {
                    l.updated(key, value);
                }
            }
        }
    }

    protected abstract void remove(Object var1, Object var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removed(Object key, Object value) {
        List<ActiveChangeListener> list = this._listeners;
        synchronized (list) {
            if (this._listeners.size() > 0) {
                for (ActiveChangeListener l : this._listeners) {
                    l.removed(key, value);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._adapter != null) {
            this._adapter.close();
        }
    }

    protected abstract ActiveCollection derive(String var1, ActiveCollectionContext var2, Predicate var3, Map<String, Object> var4);

    public abstract List<Object> query(QuerySpec var1);

    public class ActiveCollectionAdapter
    implements ActiveChangeListener {
        private ActiveCollection _parent = null;
        private ActiveCollectionContext _context = null;
        private Predicate _predicate = null;

        public ActiveCollectionAdapter(ActiveCollection parent, ActiveCollectionContext context, Predicate predicate) {
            this._parent = parent;
            this._context = context;
            this._predicate = predicate;
            this._parent.addActiveChangeListener(this);
        }

        protected ActiveCollection getParent() {
            return this._parent;
        }

        protected Predicate getPredicate() {
            return this._predicate;
        }

        protected ActiveCollectionContext getContext() {
            return this._context;
        }

        @Override
        public void inserted(Object key, Object value) {
            if (this._predicate.evaluate(this._context, value)) {
                ActiveCollection.this.insert(key, value);
            }
        }

        @Override
        public void updated(Object key, Object value) {
            if (this._predicate.evaluate(this._context, value)) {
                ActiveCollection.this.update(key, value);
            }
        }

        @Override
        public void removed(Object key, Object value) {
            if (this._predicate.evaluate(this._context, value)) {
                ActiveCollection.this.remove(key, value);
            }
        }

        public void close() {
            this._parent.removeActiveChangeListener(this);
            this._parent = null;
        }
    }
}

