/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.acs.loader.osgi;

import java.io.InputStream;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.overlord.rtgov.active.collection.AbstractACSLoader;
import org.overlord.rtgov.active.collection.ActiveCollectionManager;
import org.overlord.rtgov.active.collection.ActiveCollectionManagerAccessor;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.active.collection.util.ActiveCollectionUtil;

public class ACSActivator
extends AbstractACSLoader
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(ACSActivator.class.getName());
    private static final String ACS_JSON = "/acs.json";
    private ActiveCollectionManager _acmManager = null;
    private List<ActiveCollectionSource> _activeCollectionSources = null;

    public void start(BundleContext context) throws Exception {
        this.init();
    }

    public void stop(BundleContext context) throws Exception {
        this.close();
    }

    public void setManager(ActiveCollectionManager manager) {
        this._acmManager = manager;
    }

    public ActiveCollectionManager getManager() {
        return this._acmManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this._acmManager == null) {
            this._acmManager = ActiveCollectionManagerAccessor.getActiveCollectionManager();
        }
        if (this._acmManager == null) {
            LOG.severe("Failed to obtain reference to ActiveCollectionManager");
            throw new IllegalStateException("Failed to obtain reference to ActiveCollectionManager");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            InputStream is = ACSActivator.class.getResourceAsStream(ACS_JSON);
            if (is == null) {
                LOG.severe(PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-1"));
            } else {
                byte[] b = new byte[is.available()];
                is.read(b);
                is.close();
                Thread.currentThread().setContextClassLoader(ACSActivator.class.getClassLoader());
                this._activeCollectionSources = ActiveCollectionUtil.deserializeACS((byte[])b);
                if (this._activeCollectionSources == null) {
                    LOG.severe(PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-2"));
                } else {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        this.preInit(acs);
                        this._acmManager.register(acs);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-3"), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void close() {
        block4: {
            if (this._acmManager != null && this._activeCollectionSources != null) {
                try {
                    for (ActiveCollectionSource acs : this._activeCollectionSources) {
                        this._acmManager.unregister(acs);
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.FINER)) break block4;
                    LOG.log(Level.FINER, PropertyResourceBundle.getBundle("acs-loader-osgi.Messages").getString("ACS-LOADER-OSGI-4"), t);
                }
            }
        }
    }
}

