/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.rtgov.active.collection.epn;

import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.overlord.rtgov.active.collection.ActiveCollectionContext;
import org.overlord.rtgov.active.collection.ActiveCollectionSource;
import org.overlord.rtgov.epn.ContextualNotificationListener;
import org.overlord.rtgov.epn.EPNManager;
import org.overlord.rtgov.epn.EPNManagerAccessor;
import org.overlord.rtgov.epn.EventList;
import org.overlord.rtgov.epn.NotificationListener;

public class EPNActiveCollectionSource
extends ActiveCollectionSource {
    private static final Logger LOG = Logger.getLogger(EPNActiveCollectionSource.class.getName());
    private EPNManager _epnManager = null;
    private String _subject = null;
    private ClassLoader _contextClassLoader = null;
    private boolean _preinitialized = false;
    private EPNACSNotificationListener _listener = new EPNACSNotificationListener();

    protected void setEPNManager(EPNManager mgr) {
        this._epnManager = mgr;
    }

    public void setSubject(String subject) {
        this._subject = subject;
    }

    public String getSubject() {
        return this._subject;
    }

    public void init(ActiveCollectionContext context) throws Exception {
        super.init(context);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Initializing EPN Active Collection Source");
        }
        if (this._epnManager == null) {
            this._epnManager = EPNManagerAccessor.getEPNManager();
        }
        if (this._epnManager == null) {
            LOG.severe(PropertyResourceBundle.getBundle("acs-epn.Messages").getString("ACS-EPN-1"));
            throw new IllegalStateException(PropertyResourceBundle.getBundle("acs-epn.Messages").getString("ACS-EPN-1"));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Register notification listener on EPNManagr (" + this._epnManager + ") for subject=" + this._subject);
        }
        this._epnManager.addNotificationListener(this._subject, (NotificationListener)this._listener);
    }

    protected void preInit() throws Exception {
        if (!this._preinitialized) {
            this._preinitialized = true;
            super.preInit();
            this._contextClassLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    protected void aggregateEvents(String subject, EventList events) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("aggregateEvents subject=" + subject + "events=" + events);
        }
        for (int i = 0; i < events.size(); ++i) {
            this.aggregateEvent(events.get(i));
        }
    }

    public void close() throws Exception {
        super.close();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Closing EPN Active Collection Source");
        }
        this._epnManager.removeNotificationListener(this._subject, (NotificationListener)this._listener);
    }

    protected boolean isRelevant(String subject) {
        boolean ret = true;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("isRelevant subject=" + subject + "?");
        }
        if (this._subject != null && !subject.equals(this._subject)) {
            ret = false;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("isRelevant subject=" + subject + " ret=" + ret);
        }
        return ret;
    }

    protected void processNotification(String subject, EventList events) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("processNotification subject=" + subject + " events=" + events);
        }
        for (int i = 0; i < events.size(); ++i) {
            this.maintainEntry(null, events.get(i));
        }
    }

    public class EPNACSNotificationListener
    extends ContextualNotificationListener {
        public ClassLoader getContextClassLoader() {
            return EPNActiveCollectionSource.this._contextClassLoader;
        }

        public void handleEvents(String subject, EventList events) {
            if (EPNActiveCollectionSource.this.isRelevant(subject)) {
                if (EPNActiveCollectionSource.this.getAggregationDuration() > 0L && EPNActiveCollectionSource.this.getGroupBy() != null) {
                    EPNActiveCollectionSource.this.aggregateEvents(subject, events);
                } else {
                    EPNActiveCollectionSource.this.processNotification(subject, events);
                }
            }
        }
    }
}

