/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server.discovery;

import java.io.File;
import java.io.IOException;
import org.overlord.commons.dev.server.DevServerModule;
import org.overlord.commons.dev.server.discovery.AbstractModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.ModuleDiscoveryContext;
import org.overlord.commons.dev.server.util.ArchiveUtils;

public class JarModuleFromMavenDiscoveryStrategy
extends AbstractModuleDiscoveryStrategy {
    private final Class<?> someClass;
    private final String pathInJar;

    public JarModuleFromMavenDiscoveryStrategy(Class<?> someClass, String pathInJar) {
        this.someClass = someClass;
        this.pathInJar = pathInJar;
    }

    @Override
    public String getName() {
        return "Maven JAR module";
    }

    @Override
    public DevServerModule discover(ModuleDiscoveryContext context) {
        String path = this.someClass.getClassLoader().getResource(this.someClass.getName().replace('.', '/') + ".class").getPath();
        if (path == null) {
            return null;
        }
        this.debug("Path: " + path);
        File file = new File(path);
        if (!file.exists() && path.contains(".jar") && path.startsWith("file:")) {
            String pathToJar = path.substring(5, path.indexOf(".jar")) + ".jar";
            this.debug("Path to JAR: " + pathToJar);
            File jar = new File(pathToJar);
            if (jar.isFile()) {
                File workDir = new File(context.getTargetDir(), jar.getName());
                this.debug("Work Dir: " + workDir);
                DevServerModule module = new DevServerModule();
                module.setInIDE(false);
                module.setWorkDir(workDir);
                module.clean();
                workDir.mkdirs();
                try {
                    ArchiveUtils.unpackToWorkDir(jar, workDir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                File moduleDir = new File(workDir, this.pathInJar);
                if (!moduleDir.exists()) {
                    throw new RuntimeException("JAR found (" + jar + "), but path-in-JAR not found: " + this.pathInJar);
                }
                module.setModuleDir(moduleDir);
                return module;
            }
        }
        return null;
    }
}

