/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server.discovery;

import java.io.File;
import org.overlord.commons.dev.server.DevServerModule;
import org.overlord.commons.dev.server.discovery.AbstractModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.ModuleDiscoveryContext;

public class JarModuleFromIDEDiscoveryStrategy
extends AbstractModuleDiscoveryStrategy {
    private final Class<?> someClass;
    private final String pathInProject;

    public JarModuleFromIDEDiscoveryStrategy(Class<?> someClass, String pathInProject) {
        this.someClass = someClass;
        this.pathInProject = pathInProject;
    }

    @Override
    public String getName() {
        return "IDE (jar project)";
    }

    @Override
    public DevServerModule discover(ModuleDiscoveryContext context) {
        String path = this.someClass.getClassLoader().getResource(this.someClass.getName().replace('.', '/') + ".class").getPath();
        if (path == null) {
            return null;
        }
        this.debug("Path: " + path);
        File file = new File(path);
        if (file.exists() && path.contains("/target/classes/")) {
            String pathToProj = path.substring(0, path.indexOf("/target/classes/"));
            this.debug("Path to project: " + pathToProj);
            File modulePath = new File(pathToProj, this.pathInProject);
            this.debug("Module Path: " + modulePath);
            if (!modulePath.exists()) {
                return null;
            }
            DevServerModule module = new DevServerModule();
            module.setInIDE(true);
            module.setModuleDir(modulePath);
            return module;
        }
        return null;
    }
}

