/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server;

import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.overlord.commons.dev.server.DevServerModule;
import org.overlord.commons.dev.server.discovery.IModuleDiscoveryStrategy;
import org.overlord.commons.dev.server.discovery.ModuleDiscoveryContext;

public abstract class DevServerEnvironment {
    private File targetDir;
    private Map<String, DevServerModule> modules = new HashMap<String, DevServerModule>();
    private boolean usingClassHiderAgent = false;

    public DevServerEnvironment(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                DevServerEnvironment.this.onVmExit();
            }
        }));
        this.findTargetDir();
        this.detectAgent();
        this.inspectArgs(args);
    }

    protected void onVmExit() {
        for (DevServerModule module : this.modules.values()) {
            module.clean();
        }
    }

    public boolean isModuleInIDE(String moduleId) {
        DevServerModule module = this.getModule(moduleId);
        return module.isInIDE();
    }

    public File getModuleWorkDir(String moduleId) {
        DevServerModule module = this.getModule(moduleId);
        return module.getWorkDir();
    }

    public File getModuleDir(String moduleId) {
        DevServerModule module = this.getModule(moduleId);
        return module.getModuleDir();
    }

    public DevServerModule getModule(String moduleId) {
        DevServerModule module = this.modules.get(moduleId);
        if (module == null) {
            throw new RuntimeException("Module not found: " + moduleId + " (perhaps it wasn't added via addAndConfigureModules()?)");
        }
        return module;
    }

    public void addModule(String moduleId, IModuleDiscoveryStrategy ... discoveryStrategies) {
        System.out.println("---------------------");
        System.out.println("Discovering module: " + moduleId);
        ModuleDiscoveryContext ctx = new ModuleDiscoveryContext(this.getTargetDir());
        for (IModuleDiscoveryStrategy strategy : discoveryStrategies) {
            DevServerModule module = strategy.discover(ctx);
            if (module == null) continue;
            this.modules.put(moduleId, module);
            System.out.println("Module found from " + strategy.getName());
            System.out.println("---------------------\n");
            return;
        }
        throw new RuntimeException("Module not found: " + moduleId);
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    private void findTargetDir() {
        String path = this.getClass().getClassLoader().getResource(this.getClass().getName().replace('.', '/') + ".class").getPath();
        if (path == null) {
            throw new RuntimeException("Failed to find target directory.");
        }
        if (!path.contains("/target/")) {
            throw new RuntimeException("Failed to find target directory.");
        }
        path = path.substring(0, path.indexOf("/target/")) + "/target";
        this.targetDir = new File(path);
        System.out.println("Detected runtime 'target' directory: " + this.targetDir);
    }

    protected void inspectArgs(String[] args) {
    }

    public boolean isUsingClassHiderAgent() {
        return this.usingClassHiderAgent;
    }

    public void setUsingClassHiderAgent(boolean usingClassHiderAgent) {
        this.usingClassHiderAgent = usingClassHiderAgent;
    }

    private void detectAgent() {
        try {
            Class.forName("org.jboss.errai.ClientLocalClassHidingAgent");
            this.usingClassHiderAgent = true;
        }
        catch (ClassNotFoundException e) {
            this.usingClassHiderAgent = false;
        }
    }

    public void createAppConfigs() throws Exception {
        File dir = new File(this.targetDir, "overlord-apps");
        if (dir.isDirectory()) {
            FileUtils.deleteDirectory((File)dir);
        }
        dir.mkdirs();
        File configFile1 = new File(dir, "srampui-overlordapp.properties");
        Properties props = new Properties();
        props.setProperty("overlordapp.app-id", "s-ramp-ui");
        props.setProperty("overlordapp.href", "/s-ramp-ui/index.html");
        props.setProperty("overlordapp.label", "S-RAMP");
        props.setProperty("overlordapp.primary-brand", "JBoss Overlord");
        props.setProperty("overlordapp.secondary-brand", "S-RAMP Repository");
        props.store(new FileWriter(configFile1), "S-RAMP UI application");
        File configFile2 = new File(dir, "dtgov-overlordapp.properties");
        props = new Properties();
        props.setProperty("overlordapp.app-id", "dtgov");
        props.setProperty("overlordapp.href", "/dtgov/index.html");
        props.setProperty("overlordapp.label", "DTGov");
        props.setProperty("overlordapp.primary-brand", "JBoss Overlord");
        props.setProperty("overlordapp.secondary-brand", "Design Time Governance");
        props.store(new FileWriter(configFile2), "DTGov UI application");
        File configFile3 = new File(dir, "gadgets-overlordapp.properties");
        props = new Properties();
        props.setProperty("overlordapp.app-id", "gadget-server");
        props.setProperty("overlordapp.href", "/gadget-web/Application.html");
        props.setProperty("overlordapp.label", "Gadget Server");
        props.setProperty("overlordapp.primary-brand", "JBoss Overlord");
        props.setProperty("overlordapp.secondary-brand", "Gadget Server");
        props.store(new FileWriter(configFile3), "Gadget Server UI application");
        System.setProperty("org.overlord.apps.config-dir", dir.getCanonicalPath());
        System.out.println("Generated app configs in: " + dir.getCanonicalPath());
    }
}

