/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.commons.dev.server;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.overlord.commons.dev.server.DevServerEnvironment;

public abstract class DevServer {
    protected final String[] args;

    public DevServer(String[] args) {
        this.args = args;
    }

    public void enableDebug() {
        System.setProperty("discovery-strategy.debug", "true");
    }

    public void disableDebug() {
        System.clearProperty("discovery-strategy.debug");
    }

    public void go() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Development Server (" + this.getClass().getSimpleName() + ")");
        this.preConfig();
        DevServerEnvironment environment = this.createDevEnvironment();
        this.addModules(environment);
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(environment, handlers);
        environment.createAppConfigs();
        int serverPort = this.serverPort();
        Server server = new Server(serverPort);
        server.setHandler((Handler)handlers);
        server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
        this.postStart(environment);
        server.join();
    }

    protected void preConfig() {
    }

    protected abstract DevServerEnvironment createDevEnvironment();

    protected abstract void addModules(DevServerEnvironment var1);

    protected abstract void addModulesToJetty(DevServerEnvironment var1, ContextHandlerCollection var2) throws Exception;

    protected void postStart(DevServerEnvironment environment) throws Exception {
    }

    protected int serverPort() {
        return 8080;
    }
}

