/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.overlord.gadgets.server.ConfiguredModule;
import org.overlord.gadgets.web.server.servlets.RestProxyAuthProvider;

public class RestProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 8689929059530563599L;
    private String proxyName;
    private String proxyUrl;
    private String authProviderClassName;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.proxyName = config.getInitParameter("proxy-name");
        if (this.proxyName == null) {
            throw new ServletException("Missing init parameter 'proxy-name'.");
        }
        this.proxyUrl = config.getInitParameter("proxy-url");
        if (this.proxyUrl == null) {
            throw new ServletException("Missing init parameter 'proxy-url'.");
        }
        this.authProviderClassName = config.getInitParameter("authentication-provider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println("Proxy inbound endpoint: " + req.getRequestURI());
        String urlStr = this.getProxyUrl(req);
        String queryString = req.getQueryString();
        if (queryString != null) {
            urlStr = urlStr + "?" + queryString;
        }
        System.out.println("Proxying to: " + urlStr);
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = String.valueOf(headerNames.nextElement());
            Enumeration headerValues = req.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = String.valueOf(headerValues.nextElement());
                conn.addRequestProperty(headerName, headerValue);
            }
        }
        RestProxyAuthProvider authProvider = this.getAuthProvider();
        if (authProvider != null) {
            authProvider.provideAuthentication(conn);
        }
        InputStream proxyUrlResponseStream = null;
        try {
            proxyUrlResponseStream = conn.getInputStream();
            resp.setStatus(conn.getResponseCode());
            for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
                String respHeaderName = entry.getKey();
                if (respHeaderName == null || respHeaderName.equalsIgnoreCase("transfer-encoding")) continue;
                for (String respHeaderValue : entry.getValue()) {
                    resp.addHeader(respHeaderName, respHeaderValue);
                }
            }
            IOUtils.copy((InputStream)proxyUrlResponseStream, (OutputStream)resp.getOutputStream());
        }
        finally {
            IOUtils.closeQuietly((InputStream)proxyUrlResponseStream);
            conn.disconnect();
        }
    }

    private String getProxyUrl(HttpServletRequest req) {
        String scheme = req.getScheme();
        String host = req.getServerName();
        String port = String.valueOf(req.getServerPort());
        return this.proxyUrl.replace("SCHEME", scheme).replace("HOST", host).replace("PORT", port);
    }

    private RestProxyAuthProvider getAuthProvider() throws ServletException {
        String classname = this.authProviderClassName;
        if (classname == null) {
            classname = ConfiguredModule.properties.getProperty("gadget-server.rest-proxy." + this.proxyName + ".authentication-provider");
        }
        if (classname != null) {
            try {
                Class<?> authProviderClass = Class.forName(classname);
                RestProxyAuthProvider authProvider = (RestProxyAuthProvider)authProviderClass.newInstance();
                authProvider.setConfiguration(this.proxyName, ConfiguredModule.properties);
                return authProvider;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return null;
    }
}

