/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.client.view;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import com.gwtplatform.mvp.client.ViewImpl;
import org.overlord.gadgets.web.client.ApplicationEntryPoint;
import org.overlord.gadgets.web.client.auth.CurrentUser;
import org.overlord.gadgets.web.client.presenter.StorePresenter;
import org.overlord.gadgets.web.client.widgets.StoreItem;
import org.overlord.gadgets.web.shared.dto.PageResponse;
import org.overlord.gadgets.web.shared.dto.StoreItemModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreViewImpl
extends ViewImpl
implements StorePresenter.StoreView {
    private LayoutPanel headerPanel;
    private DockLayoutPanel panel;
    private LayoutPanel footerPanel;
    private LayoutPanel mainPanel;
    private CurrentUser currentUser;
    private Label messageBar = new Label();

    @Inject
    public StoreViewImpl(CurrentUser user) {
        this.currentUser = user;
        this.headerPanel = new LayoutPanel();
        this.headerPanel.setStyleName("header-panel");
        HTML backToTabs = new HTML("Back to Tabs");
        backToTabs.addStyleName("header-link");
        backToTabs.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.headerPanel.add((Widget)backToTabs);
        this.headerPanel.setWidgetRightWidth((Widget)backToTabs, 5.0, Style.Unit.PX, 110.0, Style.Unit.PX);
        this.headerPanel.setWidgetTopHeight((Widget)backToTabs, 5.0, Style.Unit.PX, 28.0, Style.Unit.PX);
        this.footerPanel = new LayoutPanel();
        this.footerPanel.setStyleName("footer-panel");
        this.panel = new DockLayoutPanel(Style.Unit.PX);
        this.panel.getElement().setAttribute("id", "container");
        this.mainPanel = new LayoutPanel();
        this.mainPanel.getElement().setId("mainpanel");
        this.panel.addNorth((Widget)this.headerPanel, 25.0);
        this.panel.addSouth((Widget)this.footerPanel, 25.0);
        this.panel.add((Widget)this.mainPanel);
        this.footerPanel.add(ApplicationEntryPoint.MODULES.getFooter().asWidget());
    }

    public void loadStoreItems(PageResponse<StoreItemModel> storeItems) {
        this.mainPanel.clear();
        FlowPanel storesList = new FlowPanel();
        storesList.getElement().setId("gadget-store-list");
        storesList.setWidth("100%");
        this.messageBar.setStyleName("storeItemInfo");
        storesList.add((Widget)this.messageBar);
        for (StoreItemModel item : storeItems.getResultSet()) {
            StoreItem storeItem = new StoreItem(item, this.currentUser, this.messageBar);
            storesList.add((Widget)storeItem);
        }
        this.mainPanel.add((Widget)storesList);
    }

    public Widget asWidget() {
        return this.panel;
    }

    public void setPresenter(StorePresenter presenter) {
    }

    public void clearMessageBar() {
        this.messageBar.setText("");
    }
}

