/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class JSONPFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isJSONPRequest(httpRequest)) {
            ServletOutputStream out = response.getOutputStream();
            String varName = this.getVariableNameParameter(httpRequest);
            if (varName == null) {
                varName = "jsonpobj";
            }
            out.print("var " + varName + " = (");
            chain.doFilter(request, response);
            out.println(");");
            response.setContentType("text/javascript");
        } else {
            chain.doFilter(request, response);
        }
    }

    private String getVariableNameParameter(HttpServletRequest httpRequest) {
        return httpRequest.getParameter("varName");
    }

    private boolean isJSONPRequest(HttpServletRequest httpRequest) {
        return "true".equals(httpRequest.getParameter("jsonp"));
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

