/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server;

import com.google.gson.Gson;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.overlord.gadgets.server.model.Page;
import org.overlord.gadgets.server.model.User;
import org.overlord.gadgets.server.model.Widget;
import org.overlord.gadgets.server.model.WidgetPreference;
import org.overlord.gadgets.server.service.UserManager;
import org.overlord.gadgets.web.server.GadgetMetadataService;
import org.overlord.gadgets.web.server.GsonFactory;
import org.overlord.gadgets.web.shared.dto.PageModel;
import org.overlord.gadgets.web.shared.dto.UserModel;
import org.overlord.gadgets.web.shared.dto.UserPreference;
import org.overlord.gadgets.web.shared.dto.WidgetModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/users")
public class UserController {
    @Inject
    private UserManager userManager;
    @Inject
    private GadgetMetadataService metadataService;

    @Inject
    public UserController() {
    }

    @GET
    @Path(value="all")
    @Produces(value={"application/json"})
    public List<User> getAllUsers() {
        List users = this.userManager.getAllUser();
        return users;
    }

    @POST
    @Path(value="user")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public UserModel createUser(User user, @Context HttpServletRequest request) {
        this.userManager.createUser(user);
        return this.getUser(user, request);
    }

    @POST
    @Path(value="authentication")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public UserModel getUser(User user, @Context HttpServletRequest request) {
        User theUser = this.userManager.getUser(user.getName(), user.getPassword());
        UserModel userModel = new UserModel();
        if (theUser != null) {
            userModel.setUserId(theUser.getId());
            userModel.setUserName(theUser.getName());
            userModel.setCurrentPageId(theUser.getCurrentPageId().longValue());
            userModel.setDisplayName(theUser.getDisplayName());
            request.getSession().setAttribute("user", (Object)userModel);
        }
        return userModel;
    }

    @POST
    @Path(value="user/invalidate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response invalidSession(@Context HttpServletRequest request) {
        request.getSession().invalidate();
        return Response.ok().build();
    }

    @GET
    @Path(value="user/{username}/check")
    public Response checkUsername(@PathParam(value="username") String username) {
        boolean result = this.userManager.isUsernameExist(username);
        return this.createJsonResponse((Object)result);
    }

    @GET
    @Path(value="user/{userId}/pages")
    @Produces(value={"application/json"})
    public List<PageModel> getPageModels(@PathParam(value="userId") long userId) {
        List pages = this.userManager.getPages(userId);
        ArrayList<PageModel> pageModels = new ArrayList<PageModel>();
        for (Page page : pages) {
            PageModel pageModel = new PageModel();
            pageModel.setName(page.getName());
            pageModel.setOrder(page.getPageOrder());
            pageModel.setColumns(page.getColumns());
            pageModel.setId(page.getId());
            for (Widget widget : page.getWidgets()) {
                WidgetModel widgetModel = this.metadataService.getGadgetMetadata(widget.getAppUrl());
                widgetModel.setWidgetId(widget.getId());
                widgetModel.setOrder(Long.valueOf(widget.getOrder()));
                this.populateWidgetsDefaultValue(widget, widgetModel);
                pageModel.addModel(widgetModel);
            }
            pageModels.add(pageModel);
        }
        return pageModels;
    }

    private void populateWidgetsDefaultValue(Widget widget, WidgetModel widgetModel) {
        if (widget.getPrefs() != null && widget.getPrefs().size() > 0) {
            for (UserPreference.UserPreferenceSetting ups : widgetModel.getUserPreference().getData()) {
                for (WidgetPreference wp : widget.getPrefs()) {
                    if (!ups.getName().equals(wp.getName())) continue;
                    ups.setDefaultValue(wp.getValue());
                }
            }
        }
    }

    @POST
    @Path(value="widget/{widgetId}/remove")
    @Produces(value={"application/json"})
    public Response removeWidget(@PathParam(value="widgetId") long widgetId) {
        this.userManager.removeWidget(widgetId);
        return Response.ok().build();
    }

    @POST
    @Path(value="user/page/{pageId}/remove")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response removePage(@PathParam(value="pageId") long pageId) {
        this.userManager.removePage(pageId);
        return Response.ok().build();
    }

    @POST
    @Path(value="widget/{widgetId}/update")
    @Consumes(value={"application/json"})
    public Response updateWidgetPreference(@PathParam(value="widgetId") long widgetId, Map<String, String> prefs) {
        ArrayList<WidgetPreference> wps = new ArrayList<WidgetPreference>();
        for (String name : prefs.keySet()) {
            String value = prefs.get(name);
            WidgetPreference wp = new WidgetPreference();
            wp.setName(name);
            wp.setValue(value);
            wps.add(wp);
        }
        this.userManager.updateWidgetPreference(widgetId, wps);
        return Response.ok().build();
    }

    @POST
    @Path(value="user/{userId}/page")
    @Consumes(value={"application/json"})
    public Response createPage(@PathParam(value="userId") long userId, PageModel pageModel) {
        Page page = new Page();
        page.setName(pageModel.getName());
        page.setColumns(pageModel.getColumns());
        User theUser = this.userManager.getUserById(userId);
        Page thePage = this.userManager.addPage(page, theUser);
        return this.createJsonResponse((Object)thePage.getId());
    }

    @POST
    @Path(value="user/{userId}/current/{pageId}")
    @Consumes(value={"application/json"})
    public Response updateUserCurrentPageId(@PathParam(value="userId") long userId, @PathParam(value="pageId") long pageId) {
        User theUser = this.userManager.getUserById(userId);
        theUser.setCurrentPageId(Long.valueOf(pageId));
        this.userManager.updateUser(theUser);
        return this.createJsonResponse((Object)pageId);
    }

    private Response createJsonResponse(Object wrapper) {
        Gson gson = GsonFactory.createInstance();
        String json = gson.toJson(wrapper);
        return Response.ok((Object)json).type("application/json").build();
    }
}

