/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server.proxy;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.overlord.gadgets.web.server.proxy.XmlHttpProxy;

public class XmlHttpProxyServlet
extends HttpServlet {
    public static String REMOTE_USER = "REMOTE_USER";
    private static String XHP_LAST_MODIFIED = "xhp_last_modified_key";
    private static String DEFAULT_CONFIG = "gwt-proxy.properties";
    private static boolean allowXDomain = false;
    private static boolean requireSession = false;
    private static boolean createSession = false;
    private static String defaultContentType = "application/json";
    private static boolean rDebug = false;
    private Logger logger = null;
    private XmlHttpProxy xhp = null;
    private ServletContext ctx;
    private List<Map<String, Object>> services = null;
    private String resourcesDir = "/resources/";
    private String classpathResourcesDir = "/META-INF/resources/";
    private String headerToken = "jmaki-";
    private String testToken = "xtest-";
    private static String testUser;
    private static String testPass;
    private static String setCookie;
    private String configResource = null;

    public XmlHttpProxyServlet() {
        if (rDebug) {
            this.logger = this.getLogger();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        String createSessionString;
        String xdomainString;
        String requireSessionString;
        super.init(config);
        this.ctx = config.getServletContext();
        if (this.ctx.getInitParameter("responseContentType") != null) {
            defaultContentType = this.ctx.getInitParameter("responseContentType");
        }
        if (this.ctx.getInitParameter("jmaki-xhp-resources") != null) {
            this.resourcesDir = this.ctx.getInitParameter("jmaki-xhp-resources");
        } else if (this.ctx.getInitParameter("jmaki-resources") != null) {
            this.resourcesDir = this.ctx.getInitParameter("jmaki-resources");
        }
        if (this.ctx.getInitParameter("jmaki-classpath-resources") != null) {
            this.classpathResourcesDir = this.ctx.getInitParameter("jmaki-classpath-resources");
        }
        if ((requireSessionString = this.ctx.getInitParameter("requireSession")) == null) {
            requireSessionString = this.ctx.getInitParameter("jmaki-requireSession");
        }
        if (requireSessionString != null) {
            if ("false".equals(requireSessionString)) {
                requireSession = false;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. Session requirement disabled.");
            } else if ("true".equals(requireSessionString)) {
                requireSession = true;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. Session requirement enabled.");
            }
        }
        if ((xdomainString = this.ctx.getInitParameter("allowXDomain")) == null) {
            xdomainString = this.ctx.getInitParameter("jmaki-allowXDomain");
        }
        if (xdomainString != null) {
            if ("true".equals(xdomainString)) {
                allowXDomain = true;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. xDomain access is enabled.");
            } else if ("false".equals(xdomainString)) {
                allowXDomain = false;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. xDomain access is disabled.");
            }
        }
        if ((createSessionString = this.ctx.getInitParameter("jmaki-createSession")) != null) {
            if ("true".equals(createSessionString)) {
                createSession = true;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. create session is enabled.");
            } else if ("false".equals(xdomainString)) {
                createSession = false;
                this.getLogger().severe("XmlHttpProxyServlet: intialization. create session is disabled.");
            }
        }
        String proxyHost = this.ctx.getInitParameter("proxyHost");
        String proxyPortString = this.ctx.getInitParameter("proxyPort");
        if (proxyHost != null && proxyPortString != null) {
            int proxyPort = 8080;
            try {
                proxyPort = new Integer(proxyPortString);
                this.xhp = new XmlHttpProxy(proxyHost, proxyPort);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().severe("XmlHttpProxyServlet: intialization error. The proxyPort must be a number");
                throw new ServletException("XmlHttpProxyServlet: intialization error. The proxyPort must be a number");
            }
        } else {
            this.xhp = new XmlHttpProxy();
        }
        String servletName = config.getServletName();
        String configName = config.getInitParameter("config.name");
        this.configResource = configName != null ? configName : DEFAULT_CONFIG;
    }

    private void getServices(HttpServletResponse res) {
        this.services = new ArrayList();
        InputStream is = XmlHttpProxyServlet.class.getClassLoader().getResourceAsStream(this.configResource);
        if (null == is) {
            throw new IllegalStateException("Failed to load proxy configuration: " + this.configResource);
        }
        try {
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            HashMap<String, Object> serviceConfig = new HashMap<String, Object>();
            serviceConfig.put("id", "default");
            serviceConfig.put("url", bundle.getString("service.url"));
            serviceConfig.put("passthrough", Boolean.valueOf(bundle.getString("service.passthrough")));
            this.services.add(serviceConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load proxy configuration");
        }
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.DELETE);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.GET);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.POST);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) {
        this.doProcess(req, res, XmlHttpProxy.PUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doProcess(HttpServletRequest req, HttpServletResponse res, String method) {
        boolean isPost = XmlHttpProxy.POST.equals(method);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bodyContent = null;
        OutputStream out = null;
        PrintWriter writer = null;
        try {
            BufferedInputStream in = new BufferedInputStream((InputStream)req.getInputStream());
            int next = in.read();
            while (next > -1) {
                bos.write(next);
                next = in.read();
            }
            bodyContent = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            HttpSession session = null;
            if (createSession) {
                session = req.getSession(true);
            }
            if (requireSession && (session = req.getSession(false)) == null) {
                res.setStatus(403);
                return;
            }
            if (this.services == null || this.configUpdated()) {
                this.getServices(res);
            }
            String urlString = null;
            String xslURLString = null;
            String userName = null;
            String password = null;
            String format = "json";
            String callback = req.getParameter("callback");
            String urlParams = req.getParameter("urlparams");
            String countString = req.getParameter("count");
            boolean passthrough = false;
            if (urlParams != null) {
                urlParams = urlParams.replace(' ', '+');
            }
            HashMap<String, String> headers = null;
            Enumeration hnum = req.getHeaderNames();
            while (hnum.hasMoreElements()) {
                Enumeration vnum;
                String value;
                String name = (String)hnum.nextElement();
                if (name.startsWith(this.headerToken)) {
                    if (headers == null) {
                        headers = new HashMap<String, String>();
                    }
                    value = "";
                    vnum = req.getHeaders(name);
                    while (vnum.hasMoreElements()) {
                        value = value + (String)vnum.nextElement();
                        if (!vnum.hasMoreElements()) continue;
                        value = value + ";";
                    }
                    String sname = name.substring(this.headerToken.length(), name.length());
                    headers.put(sname, value);
                    continue;
                }
                if (name.equals("Accept")) {
                    if (headers == null) {
                        headers = new HashMap();
                    }
                    value = "";
                    vnum = req.getHeaders(name);
                    while (vnum.hasMoreElements()) {
                        value = value + (String)vnum.nextElement();
                        if (!vnum.hasMoreElements()) continue;
                        value = value + ";";
                    }
                    headers.put(name, value);
                    continue;
                }
                if (!name.startsWith(this.testToken)) continue;
                if ("xtest-user".equals(name)) {
                    testUser = req.getHeader("xtest-user");
                }
                if (!"xtest-pass".equals(name)) continue;
                testPass = req.getHeader("xtest-pass");
            }
            try {
                String actualServiceKey = "default";
                Map service = null;
                for (Map svc : this.services) {
                    if (!svc.get("id").equals(actualServiceKey)) continue;
                    service = svc;
                    break;
                }
                if (service == null) {
                    writer = res.getWriter();
                    writer.write("XmlHttpProxyServlet Error : service for id '" + actualServiceKey + "' not  found.");
                    writer.flush();
                    return;
                }
                String serviceURL = (String)service.get("url");
                if (null == serviceURL) {
                    throw new IllegalArgumentException(this.configResource + ": service url is mising");
                }
                if (service.containsKey("passthrough")) {
                    passthrough = (Boolean)service.get("passthrough");
                }
                if (null == testUser) {
                    if (service.containsKey("username")) {
                        userName = (String)service.get("username");
                    }
                    if (service.containsKey("password")) {
                        password = (String)service.get("password");
                    }
                } else {
                    userName = testUser;
                    password = testPass;
                }
                String apikey = "";
                if (service.containsKey("apikey")) {
                    apikey = (String)service.get("apikey");
                }
                if (service.containsKey("xslStyleSheet")) {
                    xslURLString = (String)service.get("xslStyleSheet");
                }
                if (!passthrough) {
                    if (urlParams == null && service.containsKey("defaultURLParams")) {
                        urlParams = (String)service.get("defaultURLParams");
                    }
                    if (urlParams != null && serviceURL.indexOf("?") == -1) {
                        serviceURL = serviceURL + "?";
                    } else if (urlParams != null) {
                        serviceURL = serviceURL + "&";
                    }
                    urlString = serviceURL + apikey;
                    if (urlParams != null) {
                        urlString = urlString + "&" + urlParams;
                    }
                }
                if (passthrough) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(serviceURL);
                    String path = req.getRequestURI();
                    String servletPath = req.getServletPath();
                    path = path.substring(path.indexOf(servletPath) + servletPath.length(), path.length());
                    StringTokenizer tok = new StringTokenizer(path, "/");
                    while (tok.hasMoreTokens()) {
                        String token = tok.nextToken();
                        if (token.indexOf(";") != -1) {
                            sb.append("/").append(token);
                            continue;
                        }
                        sb.append("/").append(URLEncoder.encode(token));
                    }
                    if (req.getQueryString() != null) {
                        sb.append("?").append(req.getQueryString());
                    }
                    urlString = sb.toString();
                }
            }
            catch (Exception ex) {
                this.getLogger().severe("XmlHttpProxyServlet Error loading service: " + ex);
                res.setStatus(500);
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("format", format);
            if (callback != null && allowXDomain) {
                paramsMap.put("callback", callback);
            }
            if (countString != null) {
                paramsMap.put("count", countString);
            }
            InputStream xslInputStream = null;
            if (urlString == null) {
                writer = res.getWriter();
                writer.write("XmlHttpProxyServlet parameters:  id[Required] urlparams[Optional] format[Optional] callback[Optional]");
                writer.flush();
                return;
            }
            if (urlString.indexOf("${") != -1) {
                urlString = this.processURL(urlString, req, res);
            }
            out = res.getOutputStream();
            if (!isPost) {
                this.xhp.processRequest(urlString, out, xslInputStream, paramsMap, headers, method, userName, password);
            } else {
                if (bodyContent == null) {
                    this.getLogger().info("XmlHttpProxyServlet attempting to post to url " + urlString + " with no body content");
                }
                this.xhp.doPost(urlString, out, xslInputStream, paramsMap, headers, bodyContent, req.getContentType(), userName, password);
            }
            res.setContentType(this.xhp.getContentType());
            res.setStatus(this.xhp.getStatus());
            return;
        }
        catch (Exception iox) {
            iox.printStackTrace();
            this.getLogger().severe("XmlHttpProxyServlet: caught " + iox);
            res.setStatus(500);
            return;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iox) {}
        }
    }

    private String processURL(String url, HttpServletRequest req, HttpServletResponse res) {
        String serviceURL = url;
        int start = url.indexOf("${");
        int end = url.indexOf("}", start);
        if (end != -1) {
            String prop = url.substring(start + 2, end).trim();
            String replace = "";
            if (REMOTE_USER.equals(prop) && req.getRemoteUser() != null) {
                replace = req.getRemoteUser();
            }
            if (prop.toLowerCase().startsWith("session.")) {
                String sessionKey = prop.substring("session.".length(), prop.length());
                if (req.getSession().getAttribute(sessionKey) != null) {
                    replace = req.getSession().getAttribute(sessionKey).toString();
                }
            }
            serviceURL = serviceURL.substring(0, start) + replace + serviceURL.substring(end + 1, serviceURL.length());
        }
        if (serviceURL.indexOf("${") != -1) {
            serviceURL = this.processURL(serviceURL, req, res);
        }
        return serviceURL;
    }

    private boolean configUpdated() {
        try {
            URL url = this.ctx.getResource(this.resourcesDir + this.configResource);
            if (url == null) {
                return false;
            }
            URLConnection con = url.openConnection();
            long lastModified = con.getLastModified();
            long XHP_LAST_MODIFIEDModified = 0L;
            if (this.ctx.getAttribute(XHP_LAST_MODIFIED) == null) {
                this.ctx.setAttribute(XHP_LAST_MODIFIED, (Object)new Long(lastModified));
                return false;
            }
            XHP_LAST_MODIFIEDModified = (Long)this.ctx.getAttribute(XHP_LAST_MODIFIED);
            if (XHP_LAST_MODIFIEDModified < lastModified) {
                this.ctx.setAttribute(XHP_LAST_MODIFIED, (Object)new Long(lastModified));
                return true;
            }
        }
        catch (Exception ex) {
            this.getLogger().severe("XmlHttpProxyServlet error checking configuration: " + ex);
        }
        return false;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("jmaki.services.xhp.Log");
            this.logger.setLevel(Level.OFF);
        }
        return this.logger;
    }

    private void logMessage(String message) {
        if (rDebug) {
            this.getLogger().info(message);
        }
    }
}

