/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.gadgets.web.server.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.overlord.gadgets.web.server.proxy.HttpClient;
import org.overlord.gadgets.web.server.proxy.ProxyConfig;
import org.overlord.gadgets.web.server.proxy.XmlHttpProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class XmlHttpProxy {
    public static String GET = "GET";
    public static String POST = "POST";
    public static String DELETE = "DELETE";
    public static String PUT = "PUT";
    private String userName = null;
    private String password = null;
    private static Logger logger;
    private String proxyHost = "";
    int proxyPort = -1;
    private Object config;
    private static String USAGE;
    private String contentType = "application/json";
    private Map<String, Cookie> cookies = new HashMap();
    int status = -1;

    public XmlHttpProxy() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getStatus() {
        return this.status;
    }

    public XmlHttpProxy(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public XmlHttpProxy(String proxyHost, int proxyPort, String userName, String password) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.userName = userName;
        this.password = password;
    }

    public void processRequest(String urlString, OutputStream out, InputStream xslInputStream, Map paramsMap, Map headers, String method, String userName, String password) throws IOException, MalformedURLException {
        this.doProcess(urlString, out, xslInputStream, paramsMap, headers, method, null, null, userName, password);
    }

    public void doPost(String urlString, OutputStream out, InputStream xslInputStream, Map paramsMap, Map headers, byte[] postData, String postContentType, String userName, String password) throws IOException, MalformedURLException {
        this.doProcess(urlString, out, xslInputStream, paramsMap, headers, POST, postData, postContentType, userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcess(String urlString, OutputStream out, InputStream xslInputStream, Map paramsMap, Map headers, String method, byte[] postData, String postContentType, String userName, String password) throws IOException, MalformedURLException {
        block25: {
            String format;
            if (paramsMap == null) {
                paramsMap = new HashMap();
            }
            if ((format = (String)paramsMap.get("format")) == null) {
                format = "xml";
            }
            InputStream in = null;
            Object os = null;
            HttpClient httpclient = null;
            1 callback = new /* Unavailable Anonymous Inner Class!! */;
            httpclient = userName != null && password != null ? new HttpClient(this.proxyHost, this.proxyPort, urlString, headers, method, userName, password, (CookieCallback)callback) : new HttpClient(this.proxyHost, this.proxyPort, urlString, headers, method, (CookieCallback)callback);
            in = postData == null ? httpclient.getInputStream() : httpclient.doPost(postData, postContentType);
            if (httpclient.getSetCookieHeader() != null) {
                String cookie = httpclient.getSetCookieHeader();
                System.out.println("'Set-Cookie' header: " + cookie);
                String[] values = cookie.split(";");
                Cookie c = new Cookie(this);
                for (String v : values) {
                    String[] tuple = v.split("=");
                    if ("Path".equals(tuple[0].trim())) {
                        c.path = tuple[1];
                        continue;
                    }
                    c.name = tuple[0].trim();
                    c.value = tuple[1];
                }
                ArrayList<String> toBeRemoved = new ArrayList<String>();
                Iterator it = this.cookies.keySet().iterator();
                while (it.hasNext()) {
                    Cookie exists = (Cookie)this.cookies.get(it.next());
                    if (!exists.name.equals(c.name)) continue;
                    String msg = exists.value.equals(c.value) ? "Replace with same value: " + exists.value : "Replace with different value: " + exists.value + "->" + c.value;
                    System.out.println("Cookie '" + exists.name + "' exists: " + msg);
                    toBeRemoved.add(exists.name);
                }
                for (String s : toBeRemoved) {
                    this.cookies.remove(s);
                }
                this.cookies.put(c.name, c);
            }
            if (null == in) {
                throw new IOException("Failed to open input stream");
            }
            String ce = httpclient.getContentEncoding();
            if (ce == null) {
                int idx;
                String ct = httpclient.getContentType();
                ce = ct != null ? ((idx = ct.lastIndexOf("charset=")) >= 0 ? ct.substring(idx + 8) : "UTF-8") : "UTF-8";
            }
            this.contentType = httpclient.getContentType();
            this.status = httpclient.getResponseCode();
            try {
                byte[] buffer = new byte[1024];
                int read = 0;
                if (xslInputStream == null) {
                    while (true) {
                        if ((read = in.read(buffer)) <= 0) {
                            break block25;
                        }
                        out.write(buffer, 0, read);
                    }
                }
                this.transform(in, xslInputStream, paramsMap, out, ce);
            }
            catch (Exception e) {
                XmlHttpProxy.getLogger().severe("XmlHttpProxy transformation error: " + e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.flush();
                        out.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    private Map<String, Cookie> accessCookies() {
        return this.cookies;
    }

    public void transform(InputStream xmlIS, InputStream xslIS, Map params, OutputStream result, String encoding) {
        try {
            TransformerFactory trFac = TransformerFactory.newInstance();
            Transformer transformer = trFac.newTransformer(new StreamSource(xslIS));
            for (String key : params.keySet()) {
                transformer.setParameter(key, (String)params.get(key));
            }
            transformer.setOutputProperty("encoding", encoding);
            transformer.transform(new StreamSource(xmlIS), new StreamResult(result));
        }
        catch (Exception e) {
            XmlHttpProxy.getLogger().severe("XmlHttpProxy: Exception with xslt " + e);
        }
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(XmlHttpProxy.class.getName());
        }
        return logger;
    }

    public static ProxyConfig loadServices(InputStream is) {
        return ProxyConfig.parse((InputStream)is);
    }

    static /* synthetic */ Map access$000(XmlHttpProxy x0) {
        return x0.accessCookies();
    }

    static {
        USAGE = "Usage:  -url service_URL  -id service_key [-url or -id required] -xslurl xsl_url [optional] -format json|xml [optional] -callback[optional] -config [optional] -resources base_directory_containing XSL stylesheets [optional]";
    }
}

