/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.workflow.brms;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.overlord.sramp.governance.workflow.Multipart;
import org.overlord.sramp.governance.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmRestClient {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    String jbpmUrl = null;
    HttpClient httpclient = null;

    public JbpmRestClient(HttpClient httpclient, String jbpmUrl) {
        this.jbpmUrl = jbpmUrl;
        this.httpclient = httpclient;
    }

    public void logon(String username, String password) throws ClientProtocolException, IOException {
        HttpGet getMethod = new HttpGet(this.jbpmUrl + "/rs/process/definitions");
        HttpResponse response = this.httpclient.execute((HttpUriRequest)getMethod);
        InputStream is = response.getEntity().getContent();
        String responseStr = IOUtils.toString((InputStream)is);
        is.close();
        if (responseStr.contains("j_security_check")) {
            HttpPost authMethod = new HttpPost(this.jbpmUrl + "/rs/process/j_security_check");
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("j_username", username));
            parameters.add(new BasicNameValuePair("j_password", password));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters, "UTF-8");
            authMethod.setEntity((HttpEntity)entity);
            response = this.httpclient.execute((HttpUriRequest)authMethod);
            response.getEntity().getContent().close();
            response = this.httpclient.execute((HttpUriRequest)getMethod);
            is = response.getEntity().getContent();
            if (this.log.isDebugEnabled()) {
                this.log.debug(IOUtils.toString((InputStream)is));
            }
            is.close();
        }
    }

    public void newProcessInstanceAndCompleteFirstTask(String processId, Map<String, Object> params) throws IOException, URISyntaxException, WorkflowException {
        URI sendTaskFormUrl = new URL(this.jbpmUrl + "/rs/form/process/" + processId + "/complete").toURI();
        new Multipart().post(this.httpclient, sendTaskFormUrl, params);
    }

    public void newProcessInstance(String processId) throws URISyntaxException, IOException {
        URI startProcessUrl = new URL(this.jbpmUrl + "/rs/process/definition/" + processId + "/new_instance").toURI();
        HttpPost newInstance = new HttpPost(startProcessUrl);
        this.httpclient.execute((HttpUriRequest)newInstance);
    }
}

