/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.SlashDecoder;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.ValueEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/update")
public class UpdateMetaDataResource {
    private static Logger logger = LoggerFactory.getLogger(UpdateMetaDataResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="classification/{value}/{uuid}")
    @Produces(value={"application/xml"})
    public Map<String, ValueEntity> addClassification(@Context HttpServletRequest request, @PathParam(value="value") String value, @PathParam(value="uuid") String uuid) throws Exception {
        HashMap<String, ValueEntity> results = new HashMap<String, ValueEntity>();
        OutputStream os = null;
        try {
            value = SlashDecoder.decode((String)value);
            uuid = SlashDecoder.decode((String)uuid);
            SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
            BaseArtifactType artifact = client.getArtifactMetaData(uuid);
            artifact.getClassifiedBy().add(value);
            client.updateArtifactMetaData(artifact);
            results.put("status", new ValueEntity("success"));
            results.put("artifactName", new ValueEntity(artifact.getName()));
            results.put("artifactCreatedBy", new ValueEntity(artifact.getCreatedBy()));
            results.put("artifactDescription", new ValueEntity(artifact.getDescription()));
        }
        catch (Exception e) {
            logger.error(Messages.i18n.format("UpdateMetaDataResource.ErrorUpdating", new Object[]{e.getMessage()}), (Throwable)e);
            results.put("status", new ValueEntity("fail"));
            results.put("message", new ValueEntity(Messages.i18n.format("UpdateMetaDataResource.ArtifactNotFound", new Object[0])));
        }
        finally {
            IOUtils.closeQuietly(os);
        }
        return results;
    }

    @POST
    @Path(value="{extendedType}/relatedto/{uuid}")
    @Produces(value={"application/xml"})
    public Response create(@PathParam(value="extendedType") String extendedType, @PathParam(value="uuid") String uuid) throws Exception {
        try {
            uuid = SlashDecoder.decode((String)uuid);
            SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
            String query = String.format("/s-ramp[@uuid='%s']", uuid);
            QueryResultSet queryResultSet = client.query(query);
            if (queryResultSet.size() == 0L) {
                return Response.serverError().status(0).build();
            }
            ArtifactSummary artifactSummary = (ArtifactSummary)queryResultSet.iterator().next();
            BaseArtifactType artifact = client.getArtifactMetaData(artifactSummary.getType(), uuid);
            ExtendedArtifactType extendedArtifactType = new ExtendedArtifactType();
            extendedArtifactType.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
            extendedArtifactType.setExtendedType(extendedType);
            for (Property property : artifact.getProperty()) {
                if (!"maven.groupId".equals(property.getPropertyName())) continue;
                extendedArtifactType.getProperty().add(property);
            }
            client.createArtifact((BaseArtifactType)extendedArtifactType);
            InputStream reply = IOUtils.toInputStream((String)"success");
            return Response.ok((Object)reply, (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            logger.error(Messages.i18n.format("UpdateMetaDataResource.ErrorCreatingArtifact", new Object[]{e.getMessage()}), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }
}

