/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.karaf.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.felix.gogo.commands.Command;
import org.overlord.commons.codec.AesEncrypter;
import org.overlord.commons.karaf.commands.configure.AbstractConfigureFabricCommand;

@Command(scope="overlord:fabric:dtgov", name="configure")
public class ConfigureFabricCommand
extends AbstractConfigureFabricCommand {
    private static String DTGOV_PROFILE_PATH = File.separator.equals("/") ? "overlord/dtgov.profile" : "overlord\\dtgov.profile";

    protected Object doExecute() throws Exception {
        super.doExecute();
        this.addHeaderProperties();
        this.configureDtgovProperties();
        return null;
    }

    private void configureDtgovProperties() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/dtgov.properties");
        Properties dtgovProps = new Properties();
        dtgovProps.load(is);
        String aesEncryptedValue = AesEncrypter.encrypt((String)this.password);
        StringBuilder aesEncrypterBuilder = new StringBuilder();
        aesEncrypterBuilder.append("$\\{crypt:").append(aesEncryptedValue).append("\\}");
        aesEncryptedValue = aesEncrypterBuilder.toString();
        for (Object key : dtgovProps.keySet()) {
            String value = (String)dtgovProps.get(key);
            if (!value.contains("${dtgov.users.workflow.password}")) continue;
            dtgovProps.put(key, aesEncryptedValue);
        }
        File dtgovFile = new File(this.getDtgovPropertiesFilePath());
        dtgovProps.store(new FileOutputStream(dtgovFile), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHeaderProperties() throws Exception {
        String filePath = this.getOverlordPropertiesFilePath();
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(new File(filePath));
            props.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            props.setProperty("overlord.headerui.apps.dtgov.href", "/dtgov-ui/");
            props.setProperty("overlord.headerui.apps.dtgov.label", "Design Time");
            props.setProperty("overlord.headerui.apps.dtgov.primary-brand", "JBoss Overlord");
            props.setProperty("overlord.headerui.apps.dtgov.secondary-brand", "Governance");
            props.store(out, null);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String getDtgovFabricProfilePath() {
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(this.getFabricProfilesPath()).append(DTGOV_PROFILE_PATH).append(File.separator);
        return fuse_config_path.toString();
    }

    private String getDtgovPropertiesFilePath() {
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(this.getDtgovFabricProfilePath()).append("dtgov.properties");
        return fuse_config_path.toString();
    }
}

