/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.rt.war.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.overlord.apiman.rt.engine.EngineResult;
import org.overlord.apiman.rt.engine.async.IAsyncResult;
import org.overlord.apiman.rt.engine.beans.PolicyFailure;
import org.overlord.apiman.rt.engine.beans.PolicyFailureType;
import org.overlord.apiman.rt.engine.beans.ServiceRequest;
import org.overlord.apiman.rt.engine.beans.ServiceResponse;
import org.overlord.apiman.rt.war.WarGateway;
import org.overlord.apiman.rt.war.WarGatewayThreadContext;
import org.overlord.apiman.rt.war.i18n.Messages;

public class WarGatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 958726685958622333L;
    private static final ObjectMapper mapper = new ObjectMapper();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "GET");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "POST");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "PUT");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doAction(req, resp, "DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction(HttpServletRequest req, HttpServletResponse resp, String action) {
        try {
            ServiceRequest srequest = this.readRequest(req);
            srequest.setType(action);
            Future futureResult = WarGateway.engine.execute(srequest);
            IAsyncResult asyncResult = (IAsyncResult)futureResult.get();
            if (asyncResult.isError()) {
                throw new Exception(asyncResult.getError());
            }
            EngineResult result = (EngineResult)asyncResult.getResult();
            if (result.isResponse()) {
                this.writeResponse(resp, result.getServiceResponse());
            } else {
                this.writeFailure(resp, result.getPolicyFailure());
            }
        }
        catch (Throwable e) {
            this.writeError(resp, e);
        }
        finally {
            WarGatewayThreadContext.reset();
        }
    }

    protected ServiceRequest readRequest(HttpServletRequest request) throws Exception {
        String apiKey = this.getApiKey(request);
        if (apiKey == null) {
            throw new Exception(Messages.i18n.format("WarGatewayServlet.MissingAPIKey", new Object[0]));
        }
        ServiceRequest srequest = WarGatewayThreadContext.getServiceRequest();
        srequest.setApiKey(apiKey);
        srequest.setDestination(this.getDestination(request));
        this.readHeaders(srequest, request);
        srequest.setBody((InputStream)request.getInputStream());
        srequest.setRawRequest((Object)request);
        srequest.setRemoteAddr(request.getRemoteAddr());
        return srequest;
    }

    protected String getApiKey(HttpServletRequest request) {
        String apiKey = request.getHeader("X-API-Key");
        if (apiKey == null || apiKey.trim().length() == 0) {
            apiKey = this.getApiKeyFromQuery(request);
        }
        return apiKey;
    }

    protected String getApiKeyFromQuery(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        int idx = queryString.indexOf("apikey=");
        if (idx >= 0) {
            int endIdx = queryString.indexOf(38, idx);
            if (endIdx == -1) {
                endIdx = queryString.length();
            }
            return queryString.substring(idx + 7, endIdx);
        }
        return null;
    }

    protected String getDestination(HttpServletRequest request) {
        String path = request.getPathInfo();
        return path;
    }

    protected void readHeaders(ServiceRequest srequest, HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hname = (String)headerNames.nextElement();
            String hval = request.getHeader(hname);
            srequest.getHeaders().put(hname, hval);
        }
    }

    protected void writeResponse(HttpServletResponse response, ServiceResponse sresponse) {
        response.setStatus(sresponse.getCode());
        Map headers = sresponse.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            String hname = (String)entry.getKey();
            String hval = (String)entry.getValue();
            response.setHeader(hname, hval);
        }
        if (sresponse.getBody() != null) {
            InputStream body = null;
            ServletOutputStream out = null;
            try {
                body = sresponse.getBody();
                out = response.getOutputStream();
                IOUtils.copy((InputStream)body, (OutputStream)out);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)body);
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFailure(HttpServletResponse resp, PolicyFailure policyFailure) {
        resp.setContentType("application/json");
        resp.setHeader("X-Policy-Failure-Type", String.valueOf(policyFailure.getType()));
        resp.setHeader("X-Policy-Failure-Message", policyFailure.getMessage());
        resp.setHeader("X-Policy-Failure-Code", String.valueOf(policyFailure.getFailureCode()));
        for (Map.Entry entry : policyFailure.getHeaders().entrySet()) {
            resp.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        int errorCode = 500;
        if (policyFailure.getType() == PolicyFailureType.Authentication) {
            errorCode = 401;
        } else if (policyFailure.getType() == PolicyFailureType.Authorization) {
            errorCode = 403;
        }
        resp.setStatus(errorCode);
        try {
            mapper.writer().writeValue((OutputStream)resp.getOutputStream(), (Object)policyFailure);
            IOUtils.closeQuietly((OutputStream)resp.getOutputStream());
        }
        catch (Exception e) {
            this.writeError(resp, (Throwable)e);
        }
    }

    protected void writeError(HttpServletResponse resp, Throwable error) {
        try {
            resp.setHeader("X-Exception", error.getMessage());
            resp.sendError(500, error.getMessage());
        }
        catch (IOException e1) {
            throw new RuntimeException(error);
        }
    }
}

