/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.rt.gateway.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.util.Collection;
import org.overlord.apiman.rt.engine.beans.ServiceRequest;
import org.overlord.apiman.rt.engine.beans.ServiceResponse;
import org.overlord.apiman.rt.gateway.undertow.UndertowGatewayServer;

public class UndertowGateway {
    private UndertowGatewayServer server;

    public void start() {
    }

    public void stop() {
        this.server.stop();
        this.server = null;
    }

    protected ServiceRequest readRequest(HttpServerExchange exchange) {
        ServiceRequest request = new ServiceRequest();
        request.setApiKey(this.getApiKey(exchange));
        request.setType(exchange.getRequestMethod().toString());
        request.setDestination(this.getDestination(exchange));
        this.readHeaders(request, exchange);
        request.setRawRequest((Object)exchange);
        return request;
    }

    protected String getOrganization(HttpServerExchange exchange) {
        String path = exchange.getRequestPath();
        return path.split("/")[1];
    }

    protected String getService(HttpServerExchange exchange) {
        String path = exchange.getRequestPath();
        return path.split("/")[2];
    }

    protected String getVersion(HttpServerExchange exchange) {
        String path = exchange.getRequestPath();
        return path.split("/")[3];
    }

    protected String getApiKey(HttpServerExchange exchange) {
        String apiKey = exchange.getRequestHeaders().getFirst("X-API-Key");
        if (apiKey == null || apiKey.trim().length() == 0) {
            apiKey = this.getApiKeyFromQuery(exchange);
        }
        return apiKey;
    }

    protected String getApiKeyFromQuery(HttpServerExchange exchange) {
        String queryString = exchange.getQueryString();
        int idx = queryString.indexOf("apikey=");
        if (idx >= 0) {
            int endIdx = queryString.indexOf(38, idx);
            if (endIdx == -1) {
                endIdx = queryString.length();
            }
            return queryString.substring(idx + 7, endIdx);
        }
        return null;
    }

    protected String getDestination(HttpServerExchange exchange) {
        String path = exchange.getRequestPath();
        int idx = -1;
        for (int i = 0; i < 4; ++i) {
            idx = path.indexOf(47, idx + 1);
        }
        return path.substring(idx);
    }

    protected void readHeaders(ServiceRequest request, HttpServerExchange exchange) {
        HeaderMap headers = exchange.getRequestHeaders();
        Collection names = headers.getHeaderNames();
        for (HttpString headerName : names) {
            String headerValue = headers.getFirst(headerName);
            request.getHeaders().put(headerName.toString(), headerValue);
        }
    }

    protected void writeResponse(HttpServerExchange exchange, ServiceResponse response) {
    }

    protected void writeError(HttpServerExchange exchange, Exception e) {
    }

    public static final void main(String[] args) {
        UndertowGateway gateway = new UndertowGateway();
        gateway.start();
        UndertowGateway undertowGateway = gateway;
        synchronized (undertowGateway) {
            while (true) {
                try {
                    gateway.wait();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

