/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.ui.server.servlets;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.overlord.apiman.dt.ui.client.shared.beans.ApiAuthConfigurationBean;
import org.overlord.apiman.dt.ui.client.shared.beans.ApiAuthType;
import org.overlord.apiman.dt.ui.client.shared.beans.ApiConfigurationBean;
import org.overlord.apiman.dt.ui.client.shared.beans.AppConfigurationBean;
import org.overlord.apiman.dt.ui.client.shared.beans.BasicAuthCredentialsBean;
import org.overlord.apiman.dt.ui.client.shared.beans.BearerTokenCredentialsBean;
import org.overlord.apiman.dt.ui.client.shared.beans.ConfigurationBean;
import org.overlord.apiman.dt.ui.client.shared.beans.UserConfigurationBean;
import org.overlord.apiman.dt.ui.server.UIVersion;
import org.overlord.apiman.dt.ui.server.auth.ITokenGenerator;
import org.overlord.apiman.dt.ui.server.servlets.AbstractUIServlet;
import org.overlord.apiman.dt.ui.server.servlets.ConfigurationServlet;

public class ConfigurationServlet
extends AbstractUIServlet {
    private static final long serialVersionUID = -1529967410524613367L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.getOutputStream().write("var APIMAN_CONFIG_DATA = ".getBytes("UTF-8"));
            JsonFactory f = new JsonFactory();
            JsonGenerator g = f.createJsonGenerator((OutputStream)response.getOutputStream(), JsonEncoding.UTF8);
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            g.setCodec((ObjectCodec)mapper);
            g.useDefaultPrettyPrinter();
            String endpoint = this.getConfig().getManagementApiEndpoint();
            if (endpoint == null) {
                endpoint = this.getDefaultEndpoint(request);
            }
            UIVersion version = UIVersion.get();
            ApiAuthType authType = this.getConfig().getManagementApiAuthType();
            ConfigurationBean configBean = new ConfigurationBean();
            configBean.setApiman(new AppConfigurationBean());
            configBean.setUser(new UserConfigurationBean());
            configBean.setApi(new ApiConfigurationBean());
            configBean.getApiman().setVersion(version.getVersionString());
            configBean.getApiman().setBuiltOn(version.getVersionDate());
            configBean.getApiman().setGatewayBaseUrl(this.getConfig().getGatewayUrl());
            configBean.getApiman().setLogoutUrl(this.getConfig().getLogoutUrl());
            configBean.getUser().setUsername(request.getRemoteUser());
            configBean.getApi().setEndpoint(endpoint);
            configBean.getApi().setAuth(new ApiAuthConfigurationBean());
            switch (1.$SwitchMap$org$overlord$apiman$dt$ui$client$shared$beans$ApiAuthType[authType.ordinal()]) {
                case 1: {
                    configBean.getApi().getAuth().setType(ApiAuthType.authToken);
                    String tokenGeneratorClassName = this.getConfig().getManagementApiAuthTokenGenerator();
                    if (tokenGeneratorClassName == null) {
                        throw new ServletException("No token generator class specified.");
                    }
                    Class<?> c = Class.forName(tokenGeneratorClassName);
                    ITokenGenerator tokenGenerator = (ITokenGenerator)c.newInstance();
                    configBean.getApi().getAuth().setBearerToken(new BearerTokenCredentialsBean());
                    configBean.getApi().getAuth().getBearerToken().setToken(tokenGenerator.generateToken(request));
                    configBean.getApi().getAuth().getBearerToken().setRefreshPeriod(tokenGenerator.getRefreshPeriod());
                    break;
                }
                case 2: {
                    configBean.getApi().getAuth().setType(ApiAuthType.basic);
                    configBean.getApi().getAuth().setBasic(new BasicAuthCredentialsBean());
                    String username = this.getConfig().getManagementApiAuthUsername();
                    String password = this.getConfig().getManagementApiAuthPassword();
                    configBean.getApi().getAuth().getBasic().setUsername(username);
                    configBean.getApi().getAuth().getBasic().setPassword(password);
                    break;
                }
                case 3: {
                    configBean.getApi().getAuth().setType(ApiAuthType.bearerToken);
                    String tokenGeneratorClassName = this.getConfig().getManagementApiAuthTokenGenerator();
                    if (tokenGeneratorClassName == null) {
                        throw new ServletException("No token generator class specified.");
                    }
                    Class<?> c = Class.forName(tokenGeneratorClassName);
                    ITokenGenerator tokenGenerator = (ITokenGenerator)c.newInstance();
                    configBean.getApi().getAuth().setBearerToken(new BearerTokenCredentialsBean());
                    configBean.getApi().getAuth().getBearerToken().setToken(tokenGenerator.generateToken(request));
                    configBean.getApi().getAuth().getBearerToken().setRefreshPeriod(tokenGenerator.getRefreshPeriod());
                    break;
                }
                case 4: {
                    configBean.getApi().getAuth().setType(ApiAuthType.samlBearerToken);
                    String tokenGeneratorClassName = this.getConfig().getManagementApiAuthTokenGenerator();
                    if (tokenGeneratorClassName == null) {
                        throw new ServletException("No token generator class specified.");
                    }
                    Class<?> c = Class.forName(tokenGeneratorClassName);
                    ITokenGenerator tokenGenerator = (ITokenGenerator)c.newInstance();
                    configBean.getApi().getAuth().setBearerToken(new BearerTokenCredentialsBean());
                    configBean.getApi().getAuth().getBearerToken().setToken(tokenGenerator.generateToken(request));
                    configBean.getApi().getAuth().getBearerToken().setRefreshPeriod(tokenGenerator.getRefreshPeriod());
                    break;
                }
            }
            g.writeObject((Object)configBean);
            g.flush();
            response.getOutputStream().write(";".getBytes("UTF-8"));
            g.close();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String getDefaultEndpoint(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append("/apiman-dt-api");
        return builder.toString();
    }
}

