/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.test.util;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.overlord.apiman.dt.api.core.impl.PolicyTemplateUtil;
import org.overlord.apiman.dt.test.server.DtApiTestServer;
import org.overlord.apiman.dt.test.server.MockGatewayServlet;
import org.overlord.apiman.test.common.util.TestPlanRunner;

public abstract class AbstractTestPlanTest {
    private static DtApiTestServer testServer = new DtApiTestServer();
    private static final boolean USE_PROXY = false;

    @BeforeClass
    public static void setup() throws Exception {
        testServer.start();
    }

    protected void runTestPlan(String planPath, ClassLoader classLoader) {
        PolicyTemplateUtil.clearCache();
        MockGatewayServlet.reset();
        String baseApiUrl = "http://localhost:" + this.getTestServerPort() + "/apiman-dt-api";
        TestPlanRunner runner = new TestPlanRunner(baseApiUrl);
        this.configureSystemProperties();
        runner.runTestPlan(planPath, classLoader);
    }

    protected int getTestServerPort() {
        return testServer.serverPort();
    }

    private void configureSystemProperties() {
        System.setProperty("apiman-dt-api.gateway.authentication.type", "Basic");
        System.setProperty("apiman-dt-api.gateway.rest-endpoint", "http://localhost:" + this.getTestServerPort() + "/mock-gateway");
        System.setProperty("apiman-dt-api.gateway.authentication.basic.user", "admin");
        System.setProperty("apiman-dt-api.gateway.authentication.basic.password", "admin");
    }

    @AfterClass
    public static void shutdown() throws Exception {
        testServer.stop();
    }
}

