/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.security.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.overlord.apiman.dt.api.beans.idm.PermissionBean;
import org.overlord.apiman.dt.api.beans.idm.PermissionType;

public class IndexedPermissions
implements Serializable {
    private static final long serialVersionUID = -474966481686691421L;
    private Set<String> qualifiedPermissions = new HashSet<String>();
    private Map<PermissionType, Set<String>> permissionToOrgsMap = new HashMap<PermissionType, Set<String>>();

    public IndexedPermissions(Set<PermissionBean> permissions) {
        this.index(permissions);
    }

    public boolean hasQualifiedPermission(PermissionType permissionName, String orgQualifier) {
        String key = this.createQualifiedPermissionKey(permissionName, orgQualifier);
        return this.qualifiedPermissions.contains(key);
    }

    public Set<String> getOrgQualifiers(PermissionType permissionName) {
        Set orgs = this.permissionToOrgsMap.get(permissionName);
        if (orgs == null) {
            orgs = Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(orgs);
    }

    private void index(Set<PermissionBean> permissions) {
        for (PermissionBean permissionBean : permissions) {
            PermissionType permissionName = permissionBean.getName();
            String orgQualifier = permissionBean.getOrganizationId();
            String qualifiedPermission = this.createQualifiedPermissionKey(permissionName, orgQualifier);
            this.qualifiedPermissions.add(qualifiedPermission);
            Set<String> orgs = this.permissionToOrgsMap.get(permissionName);
            if (orgs == null) {
                orgs = new HashSet<String>();
                this.permissionToOrgsMap.put(permissionName, orgs);
            }
            orgs.add(orgQualifier);
        }
    }

    protected String createQualifiedPermissionKey(PermissionType permissionName, String orgQualifier) {
        return permissionName.name() + "||" + orgQualifier;
    }
}

