/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.security.impl;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.overlord.apiman.dt.api.beans.idm.PermissionBean;
import org.overlord.apiman.dt.api.beans.idm.PermissionType;
import org.overlord.apiman.dt.api.core.IIdmStorage;
import org.overlord.apiman.dt.api.core.exceptions.StorageException;
import org.overlord.apiman.dt.api.security.ISecurityContext;
import org.overlord.apiman.dt.api.security.i18n.Messages;
import org.overlord.apiman.dt.api.security.impl.IndexedPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultSecurityContext
implements ISecurityContext {
    private static Logger logger = LoggerFactory.getLogger(DefaultSecurityContext.class);
    private static final ThreadLocal<HttpServletRequest> servletRequest = new ThreadLocal();
    private static final ThreadLocal<IndexedPermissions> permissions = new ThreadLocal();
    @Inject
    IIdmStorage idmStorage;

    @Override
    public String getRequestHeader(String headerName) {
        return servletRequest.get().getHeader(headerName);
    }

    @Override
    public String getCurrentUser() {
        return servletRequest.get().getRemoteUser();
    }

    @Override
    public boolean isAdmin() {
        return servletRequest.get().isUserInRole("apiadmin");
    }

    @Override
    public boolean hasPermission(PermissionType permission, String organizationId) {
        if (this.isAdmin()) {
            return true;
        }
        return this.getPermissions().hasQualifiedPermission(permission.toString(), organizationId);
    }

    @Override
    public Set<String> getPermittedOrganizations(PermissionType permission) {
        return this.getPermissions().getOrgQualifiers(permission.toString());
    }

    private IndexedPermissions getPermissions() {
        IndexedPermissions rval = permissions.get();
        if (rval == null) {
            rval = this.loadPermissions();
            permissions.set(rval);
        }
        return rval;
    }

    private IndexedPermissions loadPermissions() {
        String userId = servletRequest.get().getRemoteUser();
        try {
            return new IndexedPermissions(this.idmStorage.getPermissions(userId));
        }
        catch (StorageException e) {
            logger.error(Messages.getString("DefaultSecurityContext.ErrorLoadingPermissions") + userId, (Throwable)e);
            return new IndexedPermissions(new HashSet<PermissionBean>());
        }
    }

    protected static void setServletRequest(HttpServletRequest request) {
        servletRequest.set(request);
    }

    protected static void clearPermissions() {
        permissions.remove();
    }

    protected static void clearServletRequest() {
        servletRequest.remove();
    }
}

