/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.jpa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.overlord.apiman.dt.api.beans.apps.ApplicationBean;
import org.overlord.apiman.dt.api.beans.apps.ApplicationVersionBean;
import org.overlord.apiman.dt.api.beans.audit.AuditEntityType;
import org.overlord.apiman.dt.api.beans.audit.AuditEntryBean;
import org.overlord.apiman.dt.api.beans.contracts.ContractBean;
import org.overlord.apiman.dt.api.beans.orgs.OrganizationBean;
import org.overlord.apiman.dt.api.beans.plans.PlanBean;
import org.overlord.apiman.dt.api.beans.plans.PlanVersionBean;
import org.overlord.apiman.dt.api.beans.policies.PolicyBean;
import org.overlord.apiman.dt.api.beans.policies.PolicyType;
import org.overlord.apiman.dt.api.beans.search.PagingBean;
import org.overlord.apiman.dt.api.beans.search.SearchCriteriaBean;
import org.overlord.apiman.dt.api.beans.search.SearchResultsBean;
import org.overlord.apiman.dt.api.beans.services.ServiceBean;
import org.overlord.apiman.dt.api.beans.services.ServicePlanBean;
import org.overlord.apiman.dt.api.beans.services.ServiceVersionBean;
import org.overlord.apiman.dt.api.beans.summary.ApplicationSummaryBean;
import org.overlord.apiman.dt.api.beans.summary.ContractSummaryBean;
import org.overlord.apiman.dt.api.beans.summary.OrganizationSummaryBean;
import org.overlord.apiman.dt.api.beans.summary.PlanSummaryBean;
import org.overlord.apiman.dt.api.beans.summary.ServicePlanSummaryBean;
import org.overlord.apiman.dt.api.beans.summary.ServiceSummaryBean;
import org.overlord.apiman.dt.api.core.IApiKeyGenerator;
import org.overlord.apiman.dt.api.core.IStorage;
import org.overlord.apiman.dt.api.core.IStorageQuery;
import org.overlord.apiman.dt.api.core.exceptions.AlreadyExistsException;
import org.overlord.apiman.dt.api.core.exceptions.DoesNotExistException;
import org.overlord.apiman.dt.api.core.exceptions.StorageException;
import org.overlord.apiman.dt.api.core.util.PolicyTemplateUtil;
import org.overlord.apiman.dt.api.jpa.AbstractJpaStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JpaStorage
extends AbstractJpaStorage
implements IStorage,
IStorageQuery,
IApiKeyGenerator {
    private static Logger logger = LoggerFactory.getLogger(JpaStorage.class);

    @Override
    public void beginTx() throws StorageException {
        super.beginTx();
    }

    @Override
    public void commitTx() throws StorageException {
        super.commitTx();
    }

    @Override
    public void rollbackTx() {
        super.rollbackTx();
    }

    @Override
    public <T> void create(T bean) throws StorageException, AlreadyExistsException {
        super.create(bean);
    }

    @Override
    public <T> void update(T bean) throws StorageException, DoesNotExistException {
        super.update(bean);
    }

    @Override
    public <T> void delete(T bean) throws StorageException, DoesNotExistException {
        super.delete(bean);
    }

    @Override
    public <T> T get(Long id, Class<T> type) throws StorageException, DoesNotExistException {
        return super.get(id, type);
    }

    @Override
    public <T> T get(String id, Class<T> type) throws StorageException, DoesNotExistException {
        return super.get(id, type);
    }

    @Override
    public <T> T get(String organizationId, String id, Class<T> type) throws StorageException, DoesNotExistException {
        return super.get(organizationId, id, type);
    }

    @Override
    public <T> SearchResultsBean<T> find(SearchCriteriaBean criteria, Class<T> type) throws StorageException {
        return super.find(criteria, type);
    }

    public void createAuditEntry(AuditEntryBean entry) throws StorageException {
        super.create(entry);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditEntity(String organizationId, String entityId, String entityVersion, Class<T> type, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("when", false);
        if (organizationId != null) {
            criteria.addFilter("organizationId", organizationId, "eq");
        }
        if (entityId != null) {
            criteria.addFilter("entityId", entityId, "eq");
        }
        if (entityVersion != null) {
            criteria.addFilter("entityVersion", entityVersion, "eq");
        }
        if (type != null) {
            AuditEntityType entityType = null;
            if (type == OrganizationBean.class) {
                entityType = AuditEntityType.Organization;
            } else if (type == ApplicationBean.class) {
                entityType = AuditEntityType.Application;
            } else if (type == ServiceBean.class) {
                entityType = AuditEntityType.Service;
            } else if (type == PlanBean.class) {
                entityType = AuditEntityType.Plan;
            }
            if (entityType != null) {
                criteria.addFilter("entityType", entityType.name(), "eq");
            }
        }
        return this.find(criteria, AuditEntryBean.class);
    }

    public <T> SearchResultsBean<AuditEntryBean> auditUser(String userId, PagingBean paging) throws StorageException {
        SearchCriteriaBean criteria = new SearchCriteriaBean();
        if (paging != null) {
            criteria.setPaging(paging);
        } else {
            criteria.setPage(1);
            criteria.setPageSize(20);
        }
        criteria.setOrder("when", false);
        if (userId != null) {
            criteria.addFilter("who", userId, "eq");
        }
        return this.find(criteria, AuditEntryBean.class);
    }

    public List<OrganizationSummaryBean> getOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<OrganizationSummaryBean> orgs = new ArrayList<OrganizationSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT o from OrganizationBean o WHERE o.id IN :orgs ORDER BY o.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (OrganizationBean bean : qr) {
                OrganizationSummaryBean summary = new OrganizationSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                orgs.add(summary);
            }
            ArrayList<OrganizationSummaryBean> arrayList = orgs;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ApplicationSummaryBean> getApplicationsInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getApplicationsInOrgs(orgIds);
    }

    public List<ApplicationSummaryBean> getApplicationsInOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<ApplicationSummaryBean> rval = new ArrayList<ApplicationSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT a from ApplicationBean a WHERE a.organizationId IN :orgs ORDER BY a.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (ApplicationBean bean : qr) {
                ApplicationSummaryBean summary = new ApplicationSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                summary.setNumContracts(0);
                OrganizationBean org = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)bean.getOrganizationId());
                summary.setOrganizationId(org.getId());
                summary.setOrganizationName(org.getName());
                rval.add(summary);
            }
            ArrayList<ApplicationSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ServiceSummaryBean> getServicesInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getServicesInOrgs(orgIds);
    }

    public List<ServiceSummaryBean> getServicesInOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<ServiceSummaryBean> rval = new ArrayList<ServiceSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT s from ServiceBean s WHERE s.organizationId IN :orgs ORDER BY s.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (ServiceBean bean : qr) {
                ServiceSummaryBean summary = new ServiceSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                summary.setCreatedOn(bean.getCreatedOn());
                OrganizationBean org = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)bean.getOrganizationId());
                summary.setOrganizationId(org.getId());
                summary.setOrganizationName(org.getName());
                rval.add(summary);
            }
            ArrayList<ServiceSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public ServiceVersionBean getServiceVersion(String orgId, String serviceId, String version) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ServiceVersionBean v JOIN v.service s WHERE s.organizationId = :orgId AND s.id = :serviceId AND v.version = :version";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("serviceId", (Object)serviceId);
            query.setParameter("version", (Object)version);
            ServiceVersionBean serviceVersionBean = (ServiceVersionBean)query.getSingleResult();
            return serviceVersionBean;
        }
        catch (NoResultException e) {
            ServiceVersionBean serviceVersionBean = null;
            return serviceVersionBean;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ServiceVersionBean> getServiceVersions(String orgId, String serviceId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ServiceVersionBean v JOIN v.service s WHERE s.organizationId = :orgId AND s.id = :serviceId ORDER BY v.id DESC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("serviceId", (Object)serviceId);
            List list = query.getResultList();
            return list;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ServicePlanSummaryBean> getServiceVersionPlans(String organizationId, String serviceId, String version) throws StorageException {
        ArrayList<ServicePlanSummaryBean> plans = new ArrayList<ServicePlanSummaryBean>();
        ServiceVersionBean versionBean = this.getServiceVersion(organizationId, serviceId, version);
        Set servicePlans = versionBean.getPlans();
        for (ServicePlanBean spb : servicePlans) {
            PlanVersionBean planVersion = this.getPlanVersion(organizationId, spb.getPlanId(), spb.getVersion());
            ServicePlanSummaryBean summary = new ServicePlanSummaryBean();
            summary.setPlanId(planVersion.getPlan().getId());
            summary.setPlanName(planVersion.getPlan().getName());
            summary.setPlanDescription(planVersion.getPlan().getDescription());
            summary.setVersion(spb.getVersion());
            plans.add(summary);
        }
        return plans;
    }

    public List<ContractSummaryBean> getServiceContracts(String organizationId, String serviceId, String version, int page, int pageSize) throws StorageException {
        int start = (page - 1) * pageSize;
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT c from ContractBean c   JOIN c.service svcv   JOIN svcv.service svc   JOIN c.application appv   JOIN appv.application app  WHERE svc.id = :serviceId    AND svc.organizationId = :orgId    AND svcv.version = :version  ORDER BY app.organizationId, app.name ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("serviceId", (Object)serviceId);
            query.setParameter("version", (Object)version);
            query.setFirstResult(start);
            query.setMaxResults(pageSize);
            List contracts = query.getResultList();
            ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>(contracts.size());
            for (ContractBean contractBean : contracts) {
                ApplicationBean application = contractBean.getApplication().getApplication();
                ServiceBean service = contractBean.getService().getService();
                PlanBean plan = contractBean.getPlan().getPlan();
                OrganizationBean appOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)application.getOrganizationId());
                OrganizationBean svcOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)service.getOrganizationId());
                ContractSummaryBean csb = new ContractSummaryBean();
                csb.setAppId(application.getId());
                csb.setKey(contractBean.getKey());
                csb.setAppOrganizationId(application.getOrganizationId());
                csb.setAppOrganizationName(appOrg.getName());
                csb.setAppName(application.getName());
                csb.setAppVersion(contractBean.getApplication().getVersion());
                csb.setContractId(contractBean.getId());
                csb.setCreatedOn(contractBean.getCreatedOn());
                csb.setPlanId(plan.getId());
                csb.setPlanName(plan.getName());
                csb.setPlanVersion(contractBean.getPlan().getVersion());
                csb.setServiceDescription(service.getDescription());
                csb.setServiceId(service.getId());
                csb.setServiceName(service.getName());
                csb.setServiceOrganizationId(svcOrg.getId());
                csb.setServiceOrganizationName(svcOrg.getName());
                csb.setServiceVersion(contractBean.getService().getVersion());
                rval.add(csb);
            }
            ArrayList<ContractSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public ApplicationVersionBean getApplicationVersion(String orgId, String applicationId, String version) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ApplicationVersionBean v JOIN v.application s WHERE s.organizationId = :orgId AND s.id = :applicationId AND v.version = :version";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("applicationId", (Object)applicationId);
            query.setParameter("version", (Object)version);
            ApplicationVersionBean applicationVersionBean = (ApplicationVersionBean)query.getSingleResult();
            return applicationVersionBean;
        }
        catch (NoResultException e) {
            ApplicationVersionBean applicationVersionBean = null;
            return applicationVersionBean;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ApplicationVersionBean> getApplicationVersions(String orgId, String applicationId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from ApplicationVersionBean v JOIN v.application s WHERE s.organizationId = :orgId AND s.id = :applicationId ORDER BY v.id DESC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("applicationId", (Object)applicationId);
            List list = query.getResultList();
            return list;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<ContractSummaryBean> getApplicationContracts(String organizationId, String applicationId, String version) throws StorageException {
        ArrayList<ContractSummaryBean> rval = new ArrayList<ContractSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT c from ContractBean c   JOIN c.application appv   JOIN appv.application app  WHERE app.id = :applicationId    AND app.organizationId = :orgId    AND appv.version = :version  ORDER BY c.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("applicationId", (Object)applicationId);
            query.setParameter("version", (Object)version);
            List contracts = query.getResultList();
            for (ContractBean contractBean : contracts) {
                ApplicationBean application = contractBean.getApplication().getApplication();
                ServiceBean service = contractBean.getService().getService();
                PlanBean plan = contractBean.getPlan().getPlan();
                OrganizationBean appOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)application.getOrganizationId());
                OrganizationBean svcOrg = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)service.getOrganizationId());
                ContractSummaryBean csb = new ContractSummaryBean();
                csb.setAppId(application.getId());
                csb.setKey(contractBean.getKey());
                csb.setAppOrganizationId(application.getOrganizationId());
                csb.setAppOrganizationName(appOrg.getName());
                csb.setAppName(application.getName());
                csb.setAppVersion(contractBean.getApplication().getVersion());
                csb.setContractId(contractBean.getId());
                csb.setCreatedOn(contractBean.getCreatedOn());
                csb.setPlanId(plan.getId());
                csb.setPlanName(plan.getName());
                csb.setPlanVersion(contractBean.getPlan().getVersion());
                csb.setServiceDescription(service.getDescription());
                csb.setServiceId(service.getId());
                csb.setServiceName(service.getName());
                csb.setServiceOrganizationId(svcOrg.getId());
                csb.setServiceOrganizationName(svcOrg.getName());
                csb.setServiceVersion(contractBean.getService().getVersion());
                rval.add(csb);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
        return rval;
    }

    public List<PlanSummaryBean> getPlansInOrg(String orgId) throws StorageException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        return this.getPlansInOrgs(orgIds);
    }

    public List<PlanSummaryBean> getPlansInOrgs(Set<String> orgIds) throws StorageException {
        ArrayList<PlanSummaryBean> rval = new ArrayList<PlanSummaryBean>();
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT p from PlanBean p WHERE p.organizationId IN :orgs ORDER BY p.id ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgs", orgIds);
            List qr = query.getResultList();
            for (PlanBean bean : qr) {
                PlanSummaryBean summary = new PlanSummaryBean();
                summary.setId(bean.getId());
                summary.setName(bean.getName());
                summary.setDescription(bean.getDescription());
                OrganizationBean org = (OrganizationBean)entityManager.find(OrganizationBean.class, (Object)bean.getOrganizationId());
                summary.setOrganizationId(org.getId());
                summary.setOrganizationName(org.getName());
                rval.add(summary);
            }
            ArrayList<PlanSummaryBean> arrayList = rval;
            return arrayList;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public PlanVersionBean getPlanVersion(String orgId, String planId, String version) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from PlanVersionBean v JOIN v.plan s WHERE s.organizationId = :orgId AND s.id = :planId AND v.version = :version";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("planId", (Object)planId);
            query.setParameter("version", (Object)version);
            PlanVersionBean planVersionBean = (PlanVersionBean)query.getSingleResult();
            return planVersionBean;
        }
        catch (NoResultException e) {
            PlanVersionBean planVersionBean = null;
            return planVersionBean;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<PlanVersionBean> getPlanVersions(String orgId, String planId) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT v from PlanVersionBean v JOIN v.plan s WHERE s.organizationId = :orgId AND s.id = :planId ORDER BY v.id DESC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)orgId);
            query.setParameter("planId", (Object)planId);
            List list = query.getResultList();
            return list;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public List<PolicyBean> getPolicies(String organizationId, String entityId, String version, PolicyType type) throws StorageException {
        this.beginTx();
        try {
            EntityManager entityManager = this.getActiveEntityManager();
            String jpql = "SELECT p from PolicyBean p  WHERE p.organizationId = :orgId    AND p.entityId = :entityId    AND p.entityVersion = :entityVersion    AND p.type = :type ORDER BY p.orderIndex ASC";
            Query query = entityManager.createQuery(jpql);
            query.setParameter("orgId", (Object)organizationId);
            query.setParameter("entityId", (Object)entityId);
            query.setParameter("entityVersion", (Object)version);
            query.setParameter("type", (Object)type);
            List rval = query.getResultList();
            for (PolicyBean policyBean : rval) {
                PolicyTemplateUtil.generatePolicyDescription((PolicyBean)policyBean);
            }
            List list = rval;
            return list;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw new StorageException(t);
        }
        finally {
            this.commitTx();
        }
    }

    public String generate() {
        return UUID.randomUUID().toString();
    }
}

