/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.api.jpa;

import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JpaUtil {
    private static Logger logger = LoggerFactory.getLogger(JpaUtil.class);

    public static boolean isConstraintViolation(RollbackException e) {
        for (Object cause = e; cause != cause.getCause() && cause.getCause() != null; cause = cause.getCause()) {
            if (!cause.getClass().getSimpleName().equals("ConstraintViolationException")) continue;
            return true;
        }
        return false;
    }

    public static void rollbackQuietly(EntityManager entityManager) {
        if (entityManager.getTransaction().isActive() && entityManager.getTransaction().getRollbackOnly()) {
            try {
                entityManager.getTransaction().rollback();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

