/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.common.auth;

import java.util.Date;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.overlord.apiman.common.auth.AuthToken;

public class AuthTokenUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static final String produceToken(String principal, Set<String> roles, int expiresInMillis) {
        AuthToken authToken = AuthTokenUtil.createAuthToken(principal, roles, expiresInMillis);
        String json = AuthTokenUtil.toJSON(authToken);
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])StringUtils.getBytesUtf8((String)json)));
    }

    public static final AuthToken consumeToken(String encodedJson) throws IllegalArgumentException {
        String json = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)encodedJson));
        AuthToken token = AuthTokenUtil.fromJSON(json);
        AuthTokenUtil.validateToken(token);
        return token;
    }

    public static final void validateToken(AuthToken token) throws IllegalArgumentException {
        if (token.getExpiresOn().before(new Date())) {
            throw new IllegalArgumentException("Authentication token expired: " + token.getExpiresOn());
        }
    }

    public static final AuthToken createAuthToken(String principal, Set<String> roles, int expiresInMillis) {
        AuthToken token = new AuthToken();
        token.setIssuedOn(new Date());
        token.setExpiresOn(new Date(System.currentTimeMillis() + (long)expiresInMillis));
        token.setPrincipal(principal);
        token.setRoles(roles);
        AuthTokenUtil.signAuthToken(token);
        return token;
    }

    public static final void signAuthToken(AuthToken token) {
    }

    public static final String toJSON(AuthToken token) {
        try {
            return mapper.writer().writeValueAsString((Object)token);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final AuthToken fromJSON(String json) {
        try {
            return (AuthToken)mapper.reader(AuthToken.class).readValue(json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

