/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.service;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.common.list.ListSupplierDelegate;
import org.osgi.test.common.service.ServiceAware;
import org.osgi.test.common.service.ServiceConfiguration;
import org.osgi.test.common.service.ServiceConfigurationKey;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.inject.InjectingExtension;

public class ServiceExtension
extends InjectingExtension<InjectService> {
    public ServiceExtension() {
        super(InjectService.class, new Class[0]);
    }

    @Override
    protected boolean supportsType(TargetType targetType, ExtensionContext extensionContext) throws ParameterResolutionException {
        Object serviceType;
        if (targetType.matches(List.class) || targetType.matches(ServiceAware.class)) {
            if (targetType.hasParameterizedTypes()) {
                serviceType = (Type)targetType.getFirstGenericTypes().get();
                if (serviceType instanceof WildcardType) {
                    serviceType = Object.class;
                }
            } else {
                serviceType = Object.class;
            }
        } else {
            serviceType = targetType.getGenericType();
        }
        if (!(serviceType instanceof Class)) {
            throw new ParameterResolutionException(String.format("Element %s has an unsupported type %s for annotation @%s. Service must have non-generic type.", targetType.getName(), serviceType.getTypeName(), this.annotation().getSimpleName()));
        }
        return true;
    }

    @Override
    protected Object resolveValue(TargetType targetType, InjectService injectService, ExtensionContext extensionContext) throws ParameterResolutionException {
        Object serviceType = injectService.service();
        if (serviceType.equals(this.annotation())) {
            if (targetType.matches(List.class) || targetType.matches(ServiceAware.class)) {
                if (targetType.hasParameterizedTypes()) {
                    serviceType = (Type)targetType.getFirstGenericTypes().get();
                    if (serviceType instanceof WildcardType) {
                        serviceType = Object.class;
                    }
                } else {
                    serviceType = Object.class;
                }
            } else {
                serviceType = targetType.getType();
            }
        }
        if (!(serviceType instanceof Class)) {
            throw new ParameterResolutionException(String.format("Element %s has an unsupported type %s for annotation @%s. Service must have non-generic type.", targetType.getName(), serviceType.getTypeName(), this.annotation().getSimpleName()));
        }
        ServiceConfiguration<?> configuration = ServiceExtension.getServiceConfiguration(serviceType, injectService.filter(), injectService.filterArguments(), injectService.cardinality(), injectService.timeout(), extensionContext);
        if (targetType.matches(ServiceAware.class)) {
            return configuration;
        }
        if (targetType.matches(List.class)) {
            return new ListSupplierDelegate(() -> configuration.getServices());
        }
        return configuration.getService();
    }

    public static <S> ServiceConfiguration<S> getServiceConfiguration(Class<S> serviceType, String format, String[] args, int cardinality, long timeout, ExtensionContext extensionContext) {
        ServiceConfiguration serviceConfiguration = ((CloseableServiceConfiguration)ServiceExtension.getStore(extensionContext).getOrComputeIfAbsent((Object)new ServiceConfigurationKey(serviceType, format, args, cardinality, timeout), key -> new CloseableServiceConfiguration(new ServiceConfiguration(key).init(BundleContextExtension.getBundleContext(extensionContext))), CloseableServiceConfiguration.class)).get();
        return serviceConfiguration;
    }

    static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{ServiceExtension.class, extensionContext.getUniqueId()}));
    }

    public static class CloseableServiceConfiguration<S>
    implements ExtensionContext.Store.CloseableResource {
        private final ServiceConfiguration<S> serviceConfiguration;

        CloseableServiceConfiguration(ServiceConfiguration<S> serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
        }

        public void close() throws Exception {
            this.get().close();
        }

        public ServiceConfiguration<S> get() {
            return this.serviceConfiguration;
        }

        public String toString() {
            return this.get().toString();
        }
    }
}

