/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.context;

import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectInstalledBundle;
import org.osgi.test.common.inject.TargetType;
import org.osgi.test.common.install.BundleInstaller;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.context.BundleInstallerExtension;
import org.osgi.test.junit5.inject.InjectingExtension;

public class InstalledBundleExtension
extends InjectingExtension<InjectInstalledBundle> {
    public InstalledBundleExtension() {
        super(InjectInstalledBundle.class, Bundle.class);
    }

    public static Bundle installedBundleOf(InjectInstalledBundle injectBundle, ExtensionContext extensionContext) {
        try {
            BundleContext bc = BundleContextExtension.getBundleContext(extensionContext);
            BundleInstaller ib = BundleInstallerExtension.getBundleInstaller(extensionContext);
            String spec = injectBundle.value();
            if (spec.startsWith("http:") || spec.startsWith("https:") || spec.startsWith("file:")) {
                return ib.installBundle(new URL(spec), injectBundle.start());
            }
            return ib.installBundle(BundleInstaller.EmbeddedLocation.of((BundleContext)bc, (String)spec), injectBundle.start());
        }
        catch (MalformedURLException e) {
            throw new ExtensionConfigurationException(String.format("Could not parse URL from given String %s.", injectBundle.value()), (Throwable)e);
        }
    }

    @Override
    protected Object resolveValue(TargetType targetType, InjectInstalledBundle injectBundle, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            return InstalledBundleExtension.installedBundleOf(injectBundle, extensionContext);
        }
        catch (Exception e) {
            throw new ParameterResolutionException(String.format("@%s [%s]: couldn't resolve bundle parameter [%s]: %s", this.annotation().getSimpleName(), targetType.getName(), injectBundle.value(), e));
        }
    }
}

